/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.jquery;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import org.openqa.selenium.WebDriver;

public class JQueryEnabledPage {
    private final WebDriver driver;
    private final EnvironmentVariables environmentVariables;

    protected JQueryEnabledPage(WebDriver driver) {
        this(driver, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    protected JQueryEnabledPage(WebDriver driver, EnvironmentVariables environmentVariables) {
        this.driver = driver;
        this.environmentVariables = environmentVariables;
    }

    public static JQueryEnabledPage withDriver(WebDriver driver) {
        return new JQueryEnabledPage(driver);
    }

    public boolean isJQueryEnabled() {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
            Boolean result = (Boolean)js.executeScript("return (typeof jQuery === 'function')");
            return result != null && result != false;
        }
        return false;
    }

    public void injectJQuery() {
        this.executeScriptFrom("jquery/jquery.min.js");
    }

    protected void executeScriptFrom(String scriptSource) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            String script = this.getFileAsString(scriptSource);
            JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
            js.executeScript(script);
        }
    }

    private String getFileAsString(String resourcePath) {
        String content = "";
        try {
            URL fileUrl = this.getClass().getClassLoader().getResource(resourcePath);
            content = Resources.toString((URL)fileUrl, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    public void injectJQueryPlugins() {
        if (this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.ACTIVTE_HIGHLIGHTING.getPropertyName(), false).booleanValue()) {
            this.executeScriptFrom("jquery/jquery-thucydides-plugin.js");
        }
    }
}

