/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.util.Properties;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class MockEnvironmentVariables
implements EnvironmentVariables {
    private Properties properties = new Properties();
    private Properties values = new Properties();

    public boolean propertySetIsEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public String getValue(String name) {
        return this.values.getProperty(name);
    }

    @Override
    public String getValue(String name, String defaultValue) {
        return this.values.getProperty(name, defaultValue);
    }

    @Override
    public Integer getPropertyAsInteger(String name, Integer defaultValue) {
        String value = (String)this.properties.get(name);
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(this.properties.getProperty(name));
        }
        return defaultValue;
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (this.properties.getProperty(name) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.properties.getProperty(name, "false"));
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void setValue(String name, String value) {
        this.values.setProperty(name, value);
    }
}

