/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.LocalPreferences;

public class PropertiesFileLocalPreferences
implements LocalPreferences {
    private File homeDirectory;
    private final EnvironmentVariables environmentVariables;

    @Inject
    public PropertiesFileLocalPreferences(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.homeDirectory = new File(System.getProperty("user.home"));
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    @Override
    public void loadPreferences() throws IOException {
        File localPreferencesFile = this.getLocalPreferencesFile();
        if (localPreferencesFile.exists()) {
            Properties localPreferences = new Properties();
            localPreferences.load(new FileInputStream(localPreferencesFile));
            this.setUndefinedSystemPropertiesFrom(localPreferences);
        }
    }

    private void setUndefinedSystemPropertiesFrom(Properties localPreferences) {
        for (ThucydidesSystemProperty thucydidesProperty : ThucydidesSystemProperty.values()) {
            String propertyName = thucydidesProperty.getPropertyName();
            String localPropertyValue = localPreferences.getProperty(propertyName);
            String currentPropertyValue = this.environmentVariables.getProperty(propertyName);
            if (currentPropertyValue != null || localPropertyValue == null) continue;
            this.environmentVariables.setProperty(propertyName, localPropertyValue);
        }
    }

    private File getLocalPreferencesFile() {
        return new File(this.homeDirectory, "thucydides.properties");
    }
}

