/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import net.thucydides.core.screenshots.ScreenshotSequence;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Photographer {
    private static final int MESSAGE_DIGEST_MASK = 255;
    private static final int PNG_SUFFIX_LENGTH = ".png".length();
    private final WebDriver driver;
    private final File targetDirectory;
    private final ScreenshotSequence screenshotSequence;
    private final MessageDigest digest;
    private final Logger logger = LoggerFactory.getLogger(Photographer.class);
    private static final ScreenshotSequence DEFAULT_SCREENSHOT_SEQUENCE = new ScreenshotSequence();

    protected Logger getLogger() {
        return this.logger;
    }

    public Photographer(WebDriver driver, File targetDirectory) {
        this.driver = driver;
        this.targetDirectory = targetDirectory;
        this.screenshotSequence = DEFAULT_SCREENSHOT_SEQUENCE;
        this.digest = this.getMd5Digest();
    }

    private MessageDigest getMd5Digest() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().error("Failed to create digest for screenshot name.", (Throwable)e);
        }
        return md;
    }

    protected long nextScreenshotNumber() {
        return this.screenshotSequence.next();
    }

    private String nextScreenshotName(String prefix) {
        long nextScreenshotNumber = this.nextScreenshotNumber();
        return "screenshot-" + this.getMD5DigestFrom(prefix) + nextScreenshotNumber + ".png";
    }

    private String getMD5DigestFrom(String value) {
        byte[] messageDigest = this.digest.digest(value.getBytes());
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
        }
        return hexString.toString();
    }

    private String getTemporarySnapshotName() {
        return UUID.randomUUID() + ".png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File takeScreenshot(String prefix) {
        File screenshot = null;
        if (this.driverCanTakeSnapshots()) {
            OutputStream stream = null;
            try {
                byte[] screenshotData = (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
                if (screenshotData != null) {
                    File temporaryFolder = FileUtils.getTempDirectory();
                    String snapshotName = this.getTemporarySnapshotName();
                    screenshot = new File(temporaryFolder, snapshotName);
                    stream = new FileOutputStream(screenshot);
                    stream.write(screenshotData);
                }
                if (screenshot != null && screenshot.exists()) {
                    File file = this.saveScreenshoot(prefix, screenshot);
                    return file;
                }
            }
            catch (Throwable e) {
                this.getLogger().warn("Failed to write screenshot (possibly an out of memory error)", e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return screenshot;
    }

    protected File saveScreenshoot(String prefix, File screenshot) throws IOException {
        File savedScreenshot = new File(this.targetDirectory, this.nextScreenshotName(prefix));
        FileUtils.copyFile((File)screenshot, (File)savedScreenshot);
        this.savePageSourceFor(savedScreenshot.getAbsolutePath());
        return savedScreenshot;
    }

    private boolean driverCanTakeSnapshots() {
        if (this.driver == null) {
            return false;
        }
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).canTakeScreenshots();
        }
        return TakesScreenshot.class.isAssignableFrom(this.driver.getClass());
    }

    private void savePageSourceFor(String screenshotFile) throws IOException {
        if (WebDriver.class.isAssignableFrom(this.driver.getClass())) {
            try {
                WebDriver webdriver = this.driver;
                String pageSource = webdriver.getPageSource();
                File savedSource = new File(this.sourceCodeFileFor(screenshotFile));
                FileUtils.writeStringToFile((File)savedSource, (String)pageSource);
            }
            catch (WebDriverException e) {
                this.getLogger().warn("Failed to save screen source code", (Throwable)e);
            }
        }
    }

    private String sourceCodeFileFor(String screenshotFile) {
        String rootFilename = screenshotFile.substring(0, screenshotFile.length() - PNG_SUFFIX_LENGTH);
        return rootFilename + ".html";
    }

    public File getMatchingSourceCodeFor(File screenshot) {
        if (screenshot != null) {
            return new File(this.sourceCodeFileFor(screenshot.getAbsolutePath()));
        }
        return null;
    }
}

