/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.javascript;

import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class JavascriptExecutorFacade {
    private WebDriver driver;

    public JavascriptExecutorFacade(WebDriver driver) {
        this.driver = driver;
    }

    public Object executeScript(String script) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            JavascriptExecutor js = this.getJavascriptEnabledDriver();
            return js.executeScript(script, new Object[0]);
        }
        return null;
    }

    private WebDriver getRealDriver() {
        if (WebDriverFacade.class.isAssignableFrom(this.driver.getClass())) {
            WebDriverFacade driverFacade = (WebDriverFacade)this.driver;
            return driverFacade.getProxiedDriver();
        }
        return this.driver;
    }

    private JavascriptExecutor getJavascriptEnabledDriver() {
        return (JavascriptExecutor)this.getRealDriver();
    }
}

