/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.PageUrls;
import net.thucydides.core.pages.PagesEventListener;
import net.thucydides.core.pages.WrongPageError;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pages
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient WebDriver driver;
    private static final Logger LOGGER = LoggerFactory.getLogger(Pages.class);
    private String defaultBaseUrl;
    private final Configuration configuration;
    private WebdriverProxyFactory proxyFactory;
    private transient boolean usePreviousPage = false;
    PageObject currentPage = null;

    public Pages(Configuration configuration) {
        this.configuration = configuration;
        this.proxyFactory = WebdriverProxyFactory.getFactory();
    }

    public Pages() {
        this((Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public Pages(WebDriver driver) {
        this((Configuration)Injectors.getInjector().getInstance(Configuration.class));
        this.driver = driver;
    }

    public Pages(WebDriver driver, Configuration Configuration2) {
        this(Configuration2);
        this.driver = driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected void start() {
        this.getDriver().get(this.getStartingUrl());
    }

    public <T extends PageObject> T getAt(Class<T> pageObjectClass) {
        return this.currentPageAt(pageObjectClass);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public <T extends PageObject> T get(Class<T> pageObjectClass) {
        PageObject nextPage;
        if (this.shouldUsePreviousPage(pageObjectClass)) {
            nextPage = this.currentPage;
        } else {
            T pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            ((PageObject)pageCandidate).setDefaultBaseUrl(this.getDefaultBaseUrl());
            this.cacheCurrentPage((PageObject)pageCandidate);
            nextPage = pageCandidate;
        }
        this.usePreviousPage = false;
        return (T)nextPage;
    }

    public <T extends PageObject> T currentPageAt(Class<T> pageObjectClass) {
        PageObject nextPage;
        if (this.shouldUsePreviousPage(pageObjectClass)) {
            nextPage = this.currentPage;
        } else {
            String currentUrl;
            T pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            if (!((PageObject)pageCandidate).matchesAnyUrl() && !((PageObject)pageCandidate).compatibleWithUrl(currentUrl = this.getDriver().getCurrentUrl())) {
                this.thisIsNotThePageYourLookingFor(pageObjectClass);
            }
            ((PageObject)pageCandidate).setDefaultBaseUrl(this.getDefaultBaseUrl());
            this.cacheCurrentPage((PageObject)pageCandidate);
            nextPage = pageCandidate;
            nextPage.addJQuerySupport();
        }
        this.usePreviousPage = false;
        return (T)nextPage;
    }

    private <T extends PageObject> boolean shouldUsePreviousPage(Class<T> pageObjectClass) {
        if (!this.usePreviousPage) {
            return false;
        }
        return this.currentPageIsSameTypeAs(pageObjectClass);
    }

    private void cacheCurrentPage(PageObject newPage) {
        this.currentPage = newPage;
    }

    private <T extends PageObject> boolean currentPageIsSameTypeAs(Class<T> pageObjectClass) {
        return this.currentPage != null && this.currentPage.getClass().equals(pageObjectClass);
    }

    public boolean isCurrentPageAt(Class<? extends PageObject> pageObjectClass) {
        try {
            PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            String currentUrl = this.getDriver().getCurrentUrl();
            return pageCandidate.compatibleWithUrl(currentUrl);
        }
        catch (WrongPageError e) {
            return false;
        }
    }

    private <T extends PageObject> T getCurrentPageOfType(Class<T> pageObjectClass) {
        PageObject currentPage = null;
        try {
            Class[] constructorArgs = new Class[]{WebDriver.class};
            Constructor<T> constructor = pageObjectClass.getConstructor(constructorArgs);
            currentPage = (PageObject)constructor.newInstance(this.driver);
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("This page object does not appear have a constructor that takes a WebDriver parameter: " + pageObjectClass, (Throwable)e);
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        catch (Exception e) {
            LOGGER.info("Failed to instantiate page of type " + pageObjectClass, (Throwable)e);
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        return (T)currentPage;
    }

    private void thisIsNotThePageYourLookingFor(Class<? extends PageObject> pageObjectClass) {
        String errorDetails = "This is not the page you're looking for:\nI was looking for a page compatible with " + pageObjectClass + "\n" + "I was at the URL " + this.getDriver().getCurrentUrl();
        throw new WrongPageError(errorDetails);
    }

    public String getDefaultBaseUrl() {
        String baseUrl = this.defaultBaseUrl;
        if (StringUtils.isNotEmpty((CharSequence)this.getConfiguration().getBaseUrl())) {
            baseUrl = this.getConfiguration().getBaseUrl();
        }
        return baseUrl;
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    public String getStartingUrl() {
        return PageUrls.getUrlFrom(this.getDefaultBaseUrl());
    }

    public void notifyWhenDriverOpens() {
        PagesEventListener eventListener = new PagesEventListener(this);
        if (this.getDriver() != null && !this.usingProxiedWebDriver()) {
            this.start();
        }
        this.getProxyFactory().registerListener(eventListener);
    }

    private boolean usingProxiedWebDriver() {
        return this.getDriver() instanceof WebDriverFacade;
    }

    public Pages onSamePage() {
        this.usePreviousPage = true;
        return this;
    }
}

