/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.dao;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.statistics.model.TestRun;
import net.thucydides.core.statistics.model.TestRunTag;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderService;

public class TestOutcomeHistoryDAO {
    private static final String FIND_ALL_TEST_HISTORIES = "select t from TestRun t order by t.executionDate";
    private static final String FIND_BY_NAME = "select t from TestRun t where t.title = :title";
    private static final String FIND_TAG_BY_NAME = "select t from TestRunTag t where t.name = :name and t.code = :code";
    private static final String FIND_ALL_TAGS = "select t from TestRunTag t order by t.name";
    private static final String FIND_ALL_TAG_TYPES = "select distinct t.type from TestRunTag t order by t.type";
    private static final String COUNT_BY_NAME = "select count(t) from TestRun t where t.title = :title";
    private static final String COUNT_TESTS_BY_NAME_AND_RESULT = "select count(t) from TestRun t where t.title = :title and t.result = :result";
    private static final String COUNT_BY_TAG = "select count(t) from TestRun t where t.title = :title";
    private static final String COUNT_LATEST_TESTS_BY_TAG_AND_RESULT = "select count(test) from TestRun test  left outer join test.tags as tag where tag.name = :name and test.result = :result and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String COUNT_LATEST_TESTS_BY_TAG_TYPE_AND_RESULT = "select count(test) from TestRun test  left outer join test.tags as tag where tag.type = :type and test.result = :result and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String SELECT_LATEST_TEST_BY_TITLE = "select t from TestRun t where t.title = :title and t.executionDate =      (select max(tt.executionDate) from TestRun tt where tt.id = t.id)";
    private static final String SELECT_LATEST_TEST_BY_TAG = "select test from TestRun test  left outer join test.tags as tag where tag.name = :name and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String SELECT_LATEST_TEST_BY_TAG_TYPE = "select test from TestRun test  left outer join test.tags as tag where tag.type = :type and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String SELECT_TEST_RESULTS_BY_TAG = "select test.result from TestRun test  left outer join test.tags as tag where tag.name = :name order by test.executionDate desc";
    private static final String SELECT_TEST_RESULTS_BY_TAG_TYPE = "select test.result from TestRun test  left outer join test.tags as tag where tag.type = :type order by test.executionDate desc";
    private static final String COUNT_LATEST_TEST_BY_TAG = "select count(test) from TestRun test  left outer join test.tags as tag where tag.name = :name and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String COUNT_LATEST_TEST_BY_TAG_TYPE = "select count(test) from TestRun test  left outer join test.tags as tag where tag.type = :type and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String SELECT_TEST_RESULTS_BY_TITLE = "select test.result from TestRun test where test.title = :title order by test.executionDate desc";
    protected EntityManager entityManager;
    @Inject
    private final SystemClock clock;
    private List<TagProvider> tagProviders;

    @Inject
    public TestOutcomeHistoryDAO(EntityManager entityManager, SystemClock clock) {
        this.entityManager = entityManager;
        this.clock = clock;
        this.tagProviders = TagProviderService.getTagProviders();
    }

    public List<TestRun> findAll() {
        return this.entityManager.createQuery(FIND_ALL_TEST_HISTORIES).getResultList();
    }

    public List<TestRun> findTestRunsByTitle(String title) {
        return this.entityManager.createQuery(FIND_BY_NAME).setParameter("title", (Object)title).getResultList();
    }

    public void storeTestOutcome(TestOutcome testResult) {
        this.entityManager.getTransaction().begin();
        TestRun storedHistory = TestRun.from(testResult).at(this.clock.getCurrentTime().toDate());
        this.addTagsTo(testResult, storedHistory);
        this.entityManager.persist((Object)storedHistory);
        this.entityManager.getTransaction().commit();
    }

    private void addTagsTo(TestOutcome testResult, TestRun storedTestRun) {
        for (TagProvider tagProvider : this.tagProviders) {
            Set<TestRunTag> tags = tagProvider.getTagsFor(testResult);
            ArrayList matchedTags = Lists.newArrayList();
            for (TestRunTag tag : tags) {
                List matchingStoredTags = this.entityManager.createQuery(FIND_TAG_BY_NAME).setParameter("name", (Object)tag.getName()).setParameter("code", (Object)tag.getCode()).getResultList();
                if (matchingStoredTags.isEmpty()) continue;
                TestRunTag firstMatchingTag = (TestRunTag)matchingStoredTags.get(0);
                storedTestRun.getTags().add(firstMatchingTag);
                firstMatchingTag.getTestRuns().add(storedTestRun);
                matchedTags.add(tag);
            }
            tags.removeAll(matchedTags);
            for (TestRunTag tag : tags) {
                this.entityManager.persist((Object)tag);
                storedTestRun.getTags().add(tag);
            }
        }
    }

    public Long countTestRunsByTitle(String title) {
        return (Long)this.entityManager.createQuery("select count(t) from TestRun t where t.title = :title").setParameter("title", (Object)title).getSingleResult();
    }

    public Long countTestRunsByTitleAndResult(String title, TestResult result) {
        return (Long)this.entityManager.createQuery(COUNT_TESTS_BY_NAME_AND_RESULT).setParameter("title", (Object)title).setParameter("result", (Object)result).getSingleResult();
    }

    public List<TestRunTag> findAllTags() {
        return this.entityManager.createQuery(FIND_ALL_TAGS).getResultList();
    }

    public List<TestRunTag> getLatestTagsForTestWithTitleByTitle(String title) {
        List latestTestRuns = this.entityManager.createQuery(SELECT_LATEST_TEST_BY_TITLE).setParameter("title", (Object)title).getResultList();
        if (latestTestRuns.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(((TestRun)latestTestRuns.get(0)).getTags());
    }

    public List<TestResult> getResultsTestWithTitle(String title) {
        return this.entityManager.createQuery(SELECT_TEST_RESULTS_BY_TITLE).setParameter("title", (Object)title).getResultList();
    }

    public List<TestResult> getResultsForTestsWithTag(String tag) {
        return this.entityManager.createQuery(SELECT_TEST_RESULTS_BY_TAG).setParameter("name", (Object)tag).getResultList();
    }

    public List<TestResult> getResultsForTestsWithTagType(String tagType) {
        return this.entityManager.createQuery(SELECT_TEST_RESULTS_BY_TAG_TYPE).setParameter("type", (Object)tagType).getResultList();
    }

    public Long countTestRunsByTag(String tag) {
        return (Long)this.entityManager.createQuery(COUNT_LATEST_TEST_BY_TAG).setParameter("name", (Object)tag).getSingleResult();
    }

    public Long countTestRunsByTagType(String tagType) {
        return (Long)this.entityManager.createQuery(COUNT_LATEST_TEST_BY_TAG_TYPE).setParameter("type", (Object)tagType).getSingleResult();
    }

    public Long countTestRunsByTagAndResult(String tag, TestResult result) {
        return (Long)this.entityManager.createQuery(COUNT_LATEST_TESTS_BY_TAG_AND_RESULT).setParameter("name", (Object)tag).setParameter("result", (Object)result).getSingleResult();
    }

    public Long countTestRunsByTagTypeAndResult(String tagType, TestResult result) {
        return (Long)this.entityManager.createQuery(COUNT_LATEST_TESTS_BY_TAG_TYPE_AND_RESULT).setParameter("type", (Object)tagType).setParameter("result", (Object)result).getSingleResult();
    }

    public List<TestRunTag> getLatestTagsForTestsWithTag(String tag) {
        List latestTestRuns = this.entityManager.createQuery(SELECT_LATEST_TEST_BY_TAG).setParameter("name", (Object)tag).getResultList();
        if (latestTestRuns.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(((TestRun)latestTestRuns.get(0)).getTags());
    }

    public List<TestRunTag> getLatestTagsForTestsWithTagType(String tagType) {
        List latestTestRuns = this.entityManager.createQuery(SELECT_LATEST_TEST_BY_TAG_TYPE).setParameter("type", (Object)tagType).getResultList();
        if (latestTestRuns.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(((TestRun)latestTestRuns.get(0)).getTags());
    }

    public List<TestRun> getLatestTestsWithTag(String tag) {
        List latestTestRuns = this.entityManager.createQuery(SELECT_LATEST_TEST_BY_TAG).setParameter("name", (Object)tag).getResultList();
        return ImmutableList.copyOf((Collection)latestTestRuns);
    }

    public List<String> findAllTagTypes() {
        return this.entityManager.createQuery(FIND_ALL_TAG_TYPES).getResultList();
    }
}

