/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.annotations.WithTag;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.statistics.model.TestRunTag;
import net.thucydides.core.statistics.service.TagProvider;

public class AnnotationBasedTagProvider
implements TagProvider {
    @Override
    public Set<TestRunTag> getTagsFor(TestOutcome testOutcome) {
        if (testOutcome.getTestCase() == null) {
            return Collections.emptySet();
        }
        List<WithTag> tags = TestAnnotations.forClass(testOutcome.getTestCase()).getTagsForMethod(testOutcome.getMethodName());
        return Sets.newHashSet((Iterable)Lambda.convert(tags, this.toTestRunTags()));
    }

    private Converter<Object, TestRunTag> toTestRunTags() {
        return new Converter<Object, TestRunTag>(){

            public TestRunTag convert(Object tag) {
                WithTag withTag = (WithTag)tag;
                return new TestRunTag(withTag.type(), withTag.value(), withTag.value());
            }
        };
    }
}

