/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics;

import com.google.inject.Inject;
import java.util.List;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.statistics.With;
import net.thucydides.core.statistics.WithTitle;
import net.thucydides.core.statistics.dao.TestOutcomeHistoryDAO;
import net.thucydides.core.statistics.model.TestRun;
import net.thucydides.core.statistics.model.TestRunTag;
import net.thucydides.core.statistics.model.TestStatistics;
import net.thucydides.core.statistics.service.WithTagNamed;

public class TestStatisticsProvider {
    private final TestOutcomeHistoryDAO testOutcomeHistoryDAO;

    @Inject
    public TestStatisticsProvider(TestOutcomeHistoryDAO testOutcomeHistoryDAO) {
        this.testOutcomeHistoryDAO = testOutcomeHistoryDAO;
    }

    public List<TestRun> testRunsForTest(With withCondition) {
        if (withCondition instanceof WithTitle) {
            return this.testOutcomeHistoryDAO.findTestRunsByTitle(((WithTitle)withCondition).getTitle());
        }
        return null;
    }

    public List<TestRun> getAllTestHistories() {
        return this.testOutcomeHistoryDAO.findAll();
    }

    public TestStatistics statisticsForTests(With withCondition) {
        if (withCondition instanceof WithTitle) {
            return this.testStatisticsForTitle((WithTitle)withCondition);
        }
        if (withCondition instanceof WithTagNamed) {
            return this.testStatisticsForTestsWithTag((WithTagNamed)withCondition);
        }
        return null;
    }

    private TestStatistics testStatisticsForTestsWithTag(WithTagNamed withCondition) {
        String tag = withCondition.getTag();
        Long totalTests = this.testOutcomeHistoryDAO.countTestRunsByTag(tag);
        Long passingTests = this.testOutcomeHistoryDAO.countTestRunsByTagAndResult(tag, TestResult.SUCCESS);
        Long failingTests = this.testOutcomeHistoryDAO.countTestRunsByTagAndResult(tag, TestResult.FAILURE);
        List<TestResult> results = this.testOutcomeHistoryDAO.getResultsForTestsWithTag(tag);
        List<TestRunTag> latestTags = this.testOutcomeHistoryDAO.getLatestTagsForTestsWithTag(tag);
        return new TestStatistics(totalTests, passingTests, failingTests, results, latestTags);
    }

    private TestStatistics testStatisticsForTitle(WithTitle withCondition) {
        Long totalTests = this.testOutcomeHistoryDAO.countTestRunsByTitle(withCondition.getTitle());
        Long passingTests = this.testOutcomeHistoryDAO.countTestRunsByTitleAndResult(withCondition.getTitle(), TestResult.SUCCESS);
        Long failingTests = this.testOutcomeHistoryDAO.countTestRunsByTitleAndResult(withCondition.getTitle(), TestResult.FAILURE);
        List<TestResult> results = this.testOutcomeHistoryDAO.getResultsTestWithTitle(withCondition.getTitle());
        List<TestRunTag> latestTags = this.testOutcomeHistoryDAO.getLatestTagsForTestWithTitleByTitle(withCondition.getTitle());
        return new TestStatistics(totalTests, passingTests, failingTests, results, latestTags);
    }

    public List<TestRunTag> findAllTags() {
        return this.testOutcomeHistoryDAO.findAllTags();
    }

    public List<String> findAllTagTypes() {
        return this.testOutcomeHistoryDAO.findAllTagTypes();
    }
}

