/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.DisplayedElementLocatorFactory;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebdriverInstanceFactory;
import net.thucydides.core.webdriver.firefox.FirefoxProfileEnhancer;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.UnableToCreateProfileException;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    private final WebdriverInstanceFactory webdriverInstanceFactory;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFactory.class);
    private ProfilesIni allProfiles;
    private static final int DEFAULT_HEIGHT = 1000;
    private static final int DEFAULT_WIDTH = 800;
    private final EnvironmentVariables environmentVariables;
    private final FirefoxProfileEnhancer firefoxProfileEnhancer;

    public WebDriverFactory() {
        this(new WebdriverInstanceFactory(), (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables) {
        this(new WebdriverInstanceFactory(), environmentVariables);
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables) {
        this(webdriverInstanceFactory, environmentVariables, new FirefoxProfileEnhancer(environmentVariables));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        this.webdriverInstanceFactory = webdriverInstanceFactory;
        this.environmentVariables = environmentVariables;
        this.firefoxProfileEnhancer = firefoxProfileEnhancer;
    }

    protected ProfilesIni getAllProfiles() {
        if (this.allProfiles == null) {
            this.allProfiles = new ProfilesIni();
        }
        return this.allProfiles;
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public static Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        return driverType.getWebdriverClass();
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        try {
            WebDriver driver = this.isAFirefoxDriver(driverClass) ? this.firefoxDriverFrom(driverClass) : (this.isAnHtmlUnitDriver(driverClass) ? this.htmlunitDriverFrom(driverClass) : this.webdriverInstanceFactory.newInstanceOf(driverClass));
            JavascriptSupport.activateJavascriptSupportFor(driver);
            if (this.supportsScreenResizing(driver)) {
                this.redimensionBrowser(driver);
            }
            return driver;
        }
        catch (Exception cause) {
            LOGGER.error("Could not create new Webdriver instance", (Throwable)cause);
            throw new UnsupportedDriverException("Could not instantiate " + driverClass, cause);
        }
    }

    private WebDriver htmlunitDriverFrom(Class<? extends WebDriver> driverClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        DesiredCapabilities caps = DesiredCapabilities.firefox();
        caps.setJavascriptEnabled(true);
        return new HtmlUnitDriver((Capabilities)caps);
    }

    private WebDriver firefoxDriverFrom(Class<? extends WebDriver> driverClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        FirefoxProfile profile = this.buildFirefoxProfile();
        if (this.aProfileCouldBeCreated(profile)) {
            return this.webdriverInstanceFactory.newInstanceOf(driverClass, profile);
        }
        return this.webdriverInstanceFactory.newInstanceOf(driverClass);
    }

    private boolean aProfileCouldBeCreated(FirefoxProfile profile) {
        return profile != null;
    }

    private boolean supportsScreenResizing(WebDriver driver) {
        return this.isAFirefoxDriver(driver.getClass()) || this.isAnInternetExplorerDriver(driver.getClass());
    }

    private void redimensionBrowser(WebDriver driver) {
        int height = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.SNAPSHOT_HEIGHT.getPropertyName(), 1000);
        int width = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.SNAPSHOT_WIDTH.getPropertyName(), 800);
        this.resizeBrowserTo((JavascriptExecutor)driver, height, width);
    }

    private void resizeBrowserTo(JavascriptExecutor driver, int height, int width) {
        String resizeWindow = "window.resizeTo(" + width + "," + height + ")";
        driver.executeScript(resizeWindow, new Object[0]);
    }

    private boolean isAFirefoxDriver(Class<? extends WebDriver> driverClass) {
        return FirefoxDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAnHtmlUnitDriver(Class<? extends WebDriver> driverClass) {
        return HtmlUnitDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAnInternetExplorerDriver(Class<? extends WebDriver> driverClass) {
        return InternetExplorerDriver.class.isAssignableFrom(driverClass);
    }

    protected FirefoxProfile createNewFirefoxProfile() {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setAlwaysLoadNoFocusLib(true);
        profile.setEnableNativeEvents(true);
        return profile;
    }

    protected FirefoxProfile useExistingFirefoxProfile(File profileDirectory) {
        return new FirefoxProfile(profileDirectory);
    }

    private FirefoxProfile buildFirefoxProfile() {
        FirefoxProfile profile = null;
        try {
            String profileName = this.environmentVariables.getProperty("webdriver.firefox.profile");
            profile = profileName == null ? this.createNewFirefoxProfile() : this.getProfileFrom(profileName);
            this.firefoxProfileEnhancer.allowWindowResizeFor(profile);
            this.firefoxProfileEnhancer.enableNativeEventsFor(profile);
            if (this.shouldActivateProxy()) {
                this.activateProxyFor(profile, this.firefoxProfileEnhancer);
            }
            if (this.firefoxProfileEnhancer.shouldActivateFirebugs()) {
                LOGGER.info("Adding Firebugs to Firefox profile");
                this.firefoxProfileEnhancer.addFirebugsTo(profile);
            }
            if (this.dontAssumeUntrustedCertificateIssuer()) {
                profile.setAssumeUntrustedCertificateIssuer(false);
            }
        }
        catch (UnableToCreateProfileException unableToCreateProfileException) {
            // empty catch block
        }
        return profile;
    }

    private void activateProxyFor(FirefoxProfile profile, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        String proxyPort = this.getProxyPortFromEnvironmentVariables();
        firefoxProfileEnhancer.activateProxy(profile, proxyUrl, proxyPort);
    }

    private String getProxyPortFromEnvironmentVariables() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.PROXY_PORT.getPropertyName());
    }

    private boolean shouldActivateProxy() {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        return StringUtils.isNotEmpty((CharSequence)proxyUrl);
    }

    private String getProxyUrlFromEnvironmentVariables() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.PROXY_URL.getPropertyName());
    }

    private FirefoxProfile getProfileFrom(String profileName) {
        FirefoxProfile profile = this.getAllProfiles().getProfile(profileName);
        if (profile == null) {
            profile = this.useExistingFirefoxProfile(new File(profileName));
        }
        return profile;
    }

    private boolean dontAssumeUntrustedCertificateIssuer() {
        return this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.ASSUME_UNTRUSTED_CERTIFICATE_ISSUER.getPropertyName(), true) == false;
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver) {
        Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, configuration.getElementTimeout());
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver, int timeout) {
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, timeout);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }
}

