/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.images.SimpleImageInfo;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;

public class TestOutcome {
    private final String methodName;
    private final Class<?> testCase;
    private final List<TestStep> testSteps = new ArrayList<TestStep>();
    private Story userStory;
    private String storedTitle;
    private Set<String> issues;
    private Set<String> additionalIssues;
    private long duration;
    private final long startTime;
    private Throwable testFailureCause;
    private TestResult annotatedResult = null;
    private Stack<TestStep> groupStack = new Stack();
    private IssueTracking issueTracking;

    public TestOutcome(String methodName) {
        this(methodName, null);
    }

    public TestOutcome(String methodName, Class<?> testCase) {
        this.startTime = System.currentTimeMillis();
        this.methodName = methodName;
        this.testCase = testCase;
        this.additionalIssues = new HashSet<String>();
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        if (testCase != null) {
            this.initializeStoryFrom(testCase);
        }
    }

    public TestOutcome usingIssueTracking(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
        return this;
    }

    protected TestOutcome(String methodName, Class<?> testCase, Story userStory) {
        this.startTime = System.currentTimeMillis();
        this.methodName = methodName;
        this.testCase = testCase;
        this.additionalIssues = new HashSet<String>();
        this.userStory = userStory;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
    }

    public static TestOutcome forTest(String methodName, Class<?> testCase) {
        return new TestOutcome(methodName, testCase);
    }

    private void initializeStoryFrom(Class<?> testCase) {
        Story story = Story.testedInTestCase(testCase) != null ? Story.from(Story.testedInTestCase(testCase)) : Story.from(testCase);
        this.setUserStory(story);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static TestOutcome forTestInStory(String testName, Story story) {
        return new TestOutcome(testName, null, story);
    }

    public static TestOutcome forTestInStory(String testName, Class<?> testCase, Story story) {
        return new TestOutcome(testName, testCase, story);
    }

    public String toString() {
        return Lambda.join((Object)Lambda.extract(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).toString()));
    }

    public String getTitle() {
        if (this.storedTitle == null) {
            return this.obtainTitleFromAnnotationOrMethodName();
        }
        return this.storedTitle;
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    private String obtainTitleFromAnnotationOrMethodName() {
        String annotatedTitle = TestAnnotations.forClass(this.testCase).getAnnotatedTitleForMethod(this.methodName);
        if (annotatedTitle != null) {
            return annotatedTitle;
        }
        return NameConverter.humanize(NameConverter.withNoArguments(this.methodName));
    }

    public String getStoryTitle() {
        return this.getTitleFrom(this.userStory);
    }

    private String getTitleFrom(Story userStory) {
        return userStory.getName();
    }

    public String getReportName(ReportType type) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        return reportNamer.getNormalizedTestNameFor(this);
    }

    public String getReportName(ReportType type, String qualifier) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        if (this.shouldAddQualifier(qualifier)) {
            return reportNamer.getQualifiedTestNameFor(this, qualifier);
        }
        return reportNamer.getNormalizedTestNameFor(this);
    }

    private boolean shouldAddQualifier(String qualifier) {
        return qualifier != null;
    }

    public String getReportName() {
        return this.getReportName(ReportType.ROOT);
    }

    public String getScreenshotReportName() {
        return this.getReportName(ReportType.ROOT) + "_screenshots";
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public List<Screenshot> getScreenshots() {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        List testStepsWithScreenshots = Lambda.select(this.getFlattenedTestSteps(), (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).needsScreenshots()));
        for (TestStep currentStep : testStepsWithScreenshots) {
            screenshots.addAll(this.screenshotsIn(currentStep));
        }
        return ImmutableList.copyOf(screenshots);
    }

    private List<Screenshot> screenshotsIn(TestStep currentStep) {
        return Lambda.convert(currentStep.getScreenshots(), this.toScreenshotsFor(currentStep));
    }

    private Converter<ScreenshotAndHtmlSource, Screenshot> toScreenshotsFor(final TestStep currentStep) {
        return new Converter<ScreenshotAndHtmlSource, Screenshot>(){

            public Screenshot convert(ScreenshotAndHtmlSource from) {
                return new Screenshot(from.getScreenshotFile().getName(), currentStep.getDescription(), TestOutcome.this.widthOf(from.getScreenshotFile()), currentStep.getException());
            }
        };
    }

    private boolean weNeedAScreenshotFor(TestStep step) {
        return step.needsScreenshots();
    }

    private int widthOf(File screenshot) {
        try {
            return new SimpleImageInfo(screenshot).getWidth();
        }
        catch (IOException e) {
            return 800;
        }
    }

    public List<TestStep> getFlattenedTestSteps() {
        ArrayList<? extends TestStep> flattenedTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            flattenedTestSteps.add(step);
            if (!step.isAGroup()) continue;
            flattenedTestSteps.addAll(step.getFlattenedSteps());
        }
        return ImmutableList.copyOf(flattenedTestSteps);
    }

    public List<TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            if (step.isAGroup()) {
                leafTestSteps.addAll(step.getLeafTestSteps());
                continue;
            }
            leafTestSteps.add(step);
        }
        return ImmutableList.copyOf(leafTestSteps);
    }

    public TestResult getResult() {
        if (this.testFailureCause != null) {
            return TestResult.FAILURE;
        }
        if (this.annotatedResult != null) {
            return this.annotatedResult;
        }
        TestResultList testResults = TestResultList.of(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public TestOutcome recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.inGroup()) {
            this.getCurrentStepGroup().addChildStep(step);
        } else {
            this.testSteps.add(step);
        }
        return this;
    }

    public TestOutcome withStep(TestStep step) {
        return this.recordStep(step);
    }

    public TestOutcome andStep(TestStep step) {
        return this.recordStep(step);
    }

    private TestStep getCurrentStepGroup() {
        return this.groupStack.peek();
    }

    private boolean inGroup() {
        return !this.groupStack.empty();
    }

    public ApplicationFeature getFeature() {
        if (this.getUserStory() != null) {
            return this.obtainFeatureFromUserStory();
        }
        return null;
    }

    private ApplicationFeature obtainFeatureFromUserStory() {
        return this.getUserStory().getFeature();
    }

    public void setTitle(String title) {
        this.storedTitle = title;
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.testSteps, (Converter)new ExtractTestResultsConverter());
    }

    @Deprecated
    public void startGroup(String groupName) {
        this.recordStep(new TestStep(groupName));
        this.startGroup();
    }

    public void startGroup() {
        if (!this.testSteps.isEmpty()) {
            this.groupStack.push(this.getCurrentStep());
        }
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            this.groupStack.pop();
        }
    }

    public TestStep getCurrentStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    public TestStep getLastStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    private TestStep lastStepIn(List<TestStep> testSteps) {
        return testSteps.get(testSteps.size() - 1);
    }

    public TestStep getCurrentGroup() {
        Preconditions.checkState((boolean)this.inGroup());
        return this.groupStack.peek();
    }

    public void setUserStory(Story story) {
        this.userStory = story;
    }

    public void setTestFailureCause(Throwable cause) {
        this.testFailureCause = cause;
    }

    public Throwable getTestFailureCause() {
        return this.testFailureCause;
    }

    public void setAnnotatedResult(TestResult annotatedResult) {
        this.annotatedResult = annotatedResult;
    }

    private Set<String> issues() {
        if (!this.thereAre(this.issues)) {
            this.issues = this.readIssues();
        }
        return this.issues;
    }

    public Set<String> getIssues() {
        HashSet<String> allIssues = new HashSet<String>(this.issues());
        if (this.thereAre(this.additionalIssues)) {
            allIssues.addAll(this.additionalIssues);
        }
        return allIssues;
    }

    public Class<?> getTestCase() {
        return this.testCase;
    }

    private boolean thereAre(Set<String> anyIssues) {
        return anyIssues != null && !anyIssues.isEmpty();
    }

    public void addIssues(List<String> issues) {
        this.additionalIssues.addAll(issues);
    }

    private Set<String> readIssues() {
        HashSet<String> taggedIssues = new HashSet<String>();
        if (this.testCase != null) {
            this.addMethodLevelIssuesTo(taggedIssues);
            this.addClassLevelIssuesTo(taggedIssues);
        }
        this.addTitleLevelIssuesTo(taggedIssues);
        return taggedIssues;
    }

    private void addClassLevelIssuesTo(Set<String> issues) {
        String[] classIssues;
        String classIssue = TestAnnotations.forClass(this.testCase).getAnnotatedIssueForTestCase(this.testCase);
        if (classIssue != null) {
            issues.add(classIssue);
        }
        if ((classIssues = TestAnnotations.forClass(this.testCase).getAnnotatedIssuesForTestCase(this.testCase)) != null) {
            issues.addAll(Arrays.asList(classIssues));
        }
    }

    private void addMethodLevelIssuesTo(Set<String> issues) {
        String[] multipleIssues;
        String issue = TestAnnotations.forClass(this.testCase).getAnnotatedIssueForMethod(this.getMethodName());
        if (issue != null) {
            issues.add(issue);
        }
        if ((multipleIssues = TestAnnotations.forClass(this.testCase).getAnnotatedIssuesForMethod(this.getMethodName())) != null) {
            issues.addAll(Arrays.asList(multipleIssues));
        }
    }

    private void addTitleLevelIssuesTo(Set<String> issues) {
        List<String> titleIssues = Formatter.issuesIn(this.getTitle());
        if (!titleIssues.isEmpty()) {
            issues.addAll(titleIssues);
        }
    }

    public String getFormattedIssues() {
        Set<String> issues = this.getIssues();
        if (!issues.isEmpty()) {
            List orderedIssues = Lambda.sort(this.getIssues(), (Object)Lambda.on(String.class));
            return "(" + this.getFormatter().addLinks(StringUtils.join((Iterable)orderedIssues, (String)", ")) + ")";
        }
        return "";
    }

    public void isRelatedToIssue(String issue) {
        this.issues().add(issue);
    }

    public void lastStepFailedWith(StepFailure failure) {
        this.setTestFailureCause(failure.getException());
        TestStep lastTestStep = this.testSteps.get(this.testSteps.size() - 1);
        lastTestStep.failedWith(new StepFailureException(failure.getMessage(), failure.getException()));
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getNestedStepCount() {
        return this.getFlattenedTestSteps().size();
    }

    public Integer getSuccessCount() {
        return this.count(this.successfulSteps()).in(this.getLeafTestSteps());
    }

    public Integer getFailureCount() {
        return this.count(this.failingSteps()).in(this.getLeafTestSteps());
    }

    public Integer getIgnoredCount() {
        return this.count(this.ignoredSteps()).in(this.getLeafTestSteps());
    }

    public Integer getSkippedOrIgnoredCount() {
        return this.getIgnoredCount() + this.getSkippedCount();
    }

    public Integer getSkippedCount() {
        return this.count(this.skippedSteps()).in(this.getLeafTestSteps());
    }

    public Integer getPendingCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isPending())).size();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING || this.getStepCount() == 0;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED || this.getResult() == TestResult.IGNORED;
    }

    public Story getUserStory() {
        return this.userStory;
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        if (this.duration == 0L && this.testSteps != null && this.testSteps.size() > 0) {
            return (Long)Lambda.sum(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).getDuration());
        }
        return this.duration;
    }

    StepCountBuilder count(StepFilter filter) {
        return new StepCountBuilder(filter);
    }

    public Integer countTestSteps() {
        return this.countLeafStepsIn(this.testSteps);
    }

    private Integer countLeafStepsIn(List<TestStep> testSteps) {
        int leafCount = 0;
        for (TestStep step : testSteps) {
            if (step.isAGroup()) {
                leafCount += this.countLeafStepsIn(step.getChildren()).intValue();
                continue;
            }
            ++leafCount;
        }
        return leafCount;
    }

    StepFilter successfulSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isSuccessful();
            }
        };
    }

    StepFilter failingSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isFailure();
            }
        };
    }

    StepFilter ignoredSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isIgnored();
            }
        };
    }

    StepFilter skippedSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isSkipped();
            }
        };
    }

    abstract class StepFilter {
        StepFilter() {
        }

        abstract boolean apply(TestStep var1);
    }

    public static class StepCountBuilder {
        private final StepFilter filter;

        public StepCountBuilder(StepFilter filter) {
            this.filter = filter;
        }

        int in(List<TestStep> steps) {
            int count = 0;
            for (TestStep step : steps) {
                if (!this.filter.apply(step)) continue;
                ++count;
            }
            return count;
        }
    }

    private static class ExtractTestResultsConverter
    implements Converter<TestStep, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestStep step) {
            return step.getResult();
        }
    }
}

