/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import org.openqa.selenium.firefox.FirefoxDriver;

public class ConsoleStepListener
extends BaseStepListener {
    private final StringBuffer buffer = new StringBuffer();
    int currentIndent = 0;

    public ConsoleStepListener() {
        super(FirefoxDriver.class, null);
    }

    public String toString() {
        return this.buffer.toString();
    }

    private void push() {
        ++this.currentIndent;
    }

    private void pop() {
        --this.currentIndent;
    }

    @Override
    public void testStarted(String description) {
        this.buffer.append("TEST " + description).append("\n");
        this.push();
    }

    @Override
    public void testFinished(TestOutcome result) {
        this.pop();
        this.buffer.append("TEST DONE").append("\n");
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        this.writeIndent(this.buffer);
        this.buffer.append(description.getName()).append("\n");
        this.push();
    }

    @Override
    public void skippedStepStarted(ExecutedStepDescription description) {
        this.stepStarted(description);
    }

    private void writeIndent(StringBuffer buffer) {
        for (int i = 0; i < this.currentIndent; ++i) {
            buffer.append("-");
        }
    }

    @Override
    public void stepFinished() {
        this.pop();
        this.writeIndent(this.buffer);
        this.buffer.append("--> STEP DONE").append("\n");
    }

    @Override
    public void stepFailed(StepFailure failure) {
        this.pop();
        this.writeIndent(this.buffer);
        this.buffer.append("--> STEP FAILED").append("\n");
    }

    @Override
    public void stepIgnored() {
        this.pop();
        this.writeIndent(this.buffer);
        this.buffer.append("--> STEP IGNORED").append("\n");
    }

    @Override
    public void stepPending() {
        this.pop();
        this.writeIndent(this.buffer);
        this.buffer.append("--> STEP PENDING").append("\n");
    }

    @Override
    public void testFailed(Throwable cause) {
        this.buffer.append("--> TEST FAILED").append("\n");
    }

    @Override
    public void testIgnored() {
        this.buffer.append("--> TEST IGNORED").append("\n");
    }
}

