/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.CoverageFormatter;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.matchers.TestOutcomeMatchers;
import net.thucydides.core.statistics.HibernateTestStatisticsProvider;
import net.thucydides.core.statistics.With;
import net.thucydides.core.statistics.model.TestStatistics;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class TestOutcomes {
    private final List<? extends TestOutcome> outcomes;
    private final double estimatedAverageStepCount;
    private final String label;
    private final HibernateTestStatisticsProvider testStatisticsProvider;

    @Inject
    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label, HibernateTestStatisticsProvider testStatisticsProvider) {
        this.outcomes = ImmutableList.copyOf(outcomes);
        this.estimatedAverageStepCount = estimatedAverageStepCount;
        this.label = label;
        this.testStatisticsProvider = testStatisticsProvider;
    }

    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount) {
        this(outcomes, estimatedAverageStepCount, "", TestOutcomes.defaultTestStatisticsProvider());
    }

    private static HibernateTestStatisticsProvider defaultTestStatisticsProvider() {
        return (HibernateTestStatisticsProvider)Injectors.getInjector().getInstance(HibernateTestStatisticsProvider.class);
    }

    protected TestOutcomes withLabel(String label) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, label, TestOutcomes.defaultTestStatisticsProvider());
    }

    public static TestOutcomes of(List<? extends TestOutcome> outcomes) {
        return new TestOutcomes(outcomes, ((Configuration)Injectors.getInjector().getInstance(Configuration.class)).getEstimatedAverageStepCount());
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getTagTypes() {
        HashSet tagTypes = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            tagTypes.addAll(Lambda.extract(testOutcome.getTags(), (Object)((TestTag)Lambda.on(TestTag.class)).getType()));
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tagTypes), (Object)Lambda.on(String.class));
    }

    public List<String> getTags() {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            tags.addAll(Lambda.extract(testOutcome.getTags(), (Object)((TestTag)Lambda.on(TestTag.class)).getName()));
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    public List<String> getTagsOfType(String tagType) {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            tags.addAll(this.tagsOfType(tagType).in(testOutcome));
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    private TagFinder tagsOfType(String tagType) {
        return new TagFinder(tagType);
    }

    public TestOutcomes withTagType(String tagType) {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.havingTagType(tagType), this.outcomes)).withLabel(tagType);
    }

    public TestOutcomes withTag(String tagName) {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.havingTagName(tagName), this.outcomes)).withLabel(tagName);
    }

    public TestOutcomes withHistory() {
        return TestOutcomes.of(Lambda.convert(this.outcomes, this.toOutcomesWithHistory()));
    }

    private Converter<TestOutcome, TestOutcome> toOutcomesWithHistory() {
        return new Converter<TestOutcome, TestOutcome>(){

            public TestOutcome convert(TestOutcome testOutcome) {
                TestStatistics statistics = TestOutcomes.this.testStatisticsProvider.statisticsForTests(With.title(testOutcome.getTitle()));
                System.out.println("Statistics for " + testOutcome.getTitle() + ":" + statistics.getPassingTestRuns() + "/" + statistics.getTotalTestRuns());
                testOutcome.setStatistics(statistics);
                return testOutcome;
            }
        };
    }

    public TestOutcomes getFailingTests() {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.withResult(TestResult.FAILURE), this.outcomes)).withLabel(this.labelForTestsWithStatus("failing tests"));
    }

    private String labelForTestsWithStatus(String status) {
        if (StringUtils.isEmpty((String)this.label)) {
            return status;
        }
        return this.label + " (" + status + ")";
    }

    public TestOutcomes getPassingTests() {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.withResult(TestResult.SUCCESS), this.outcomes)).withLabel(this.labelForTestsWithStatus("passing tests"));
    }

    public TestOutcomes getPendingTests() {
        return TestOutcomes.of(Lambda.filter((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{TestOutcomeMatchers.withResult(TestResult.PENDING), TestOutcomeMatchers.withResult(TestResult.SKIPPED)}), this.outcomes)).withLabel(this.labelForTestsWithStatus("pending tests"));
    }

    public List<? extends TestOutcome> getTests() {
        return Lambda.sort(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getTitle());
    }

    public long getDuration() {
        return (Long)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getDuration());
    }

    public int getTotal() {
        return this.outcomes.size();
    }

    public TestResult getResult() {
        TestResultList testResults = TestResultList.of(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.outcomes, this.toTestResults());
    }

    private Converter<? extends TestOutcome, TestResult> toTestResults() {
        return new Converter<TestOutcome, TestResult>(){

            public TestResult convert(TestOutcome step) {
                return step.getResult();
            }
        };
    }

    public int getStepCount() {
        return Lambda.sum((Object)Lambda.extract(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount())).intValue();
    }

    public int getSuccessCount() {
        return Lambda.select(this.outcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSuccess())).size();
    }

    public int getFailureCount() {
        return Lambda.select(this.outcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isFailure())).size();
    }

    public int getPendingCount() {
        return Lambda.select(this.outcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isPending())).size();
    }

    public int getSkipCount() {
        return Lambda.select(this.outcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSkipped())).size();
    }

    public Double getPercentagePassingStepCount() {
        return (double)this.countStepsWithResultThat((Matcher<TestResult>)Matchers.is((Object)((Object)TestResult.SUCCESS))) / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentageFailingStepCount() {
        return (double)this.countStepsWithResultThat((Matcher<TestResult>)Matchers.is((Object)((Object)TestResult.FAILURE))) / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentagePendingStepCount() {
        int passingOrFailingSteps = this.countStepsWithResultThat((Matcher<TestResult>)Matchers.isOneOf((Object[])new TestResult[]{TestResult.SUCCESS, TestResult.FAILURE}));
        return (double)(this.getEstimatedTotalStepCount() - passingOrFailingSteps) / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public CoverageFormatter getFormatted() {
        return new CoverageFormatter(this.getPercentagePassingStepCount(), this.getPercentagePendingStepCount(), this.getPercentageFailingStepCount());
    }

    private int countStepsWithResultThat(Matcher<TestResult> matchingResult) {
        List matchingTests = Lambda.select(this.outcomes, (Matcher)Lambda.having((Object)((Object)((TestOutcome)Lambda.on(TestOutcome.class)).getResult()), matchingResult));
        return matchingTests.isEmpty() ? 0 : (Integer)Lambda.sum((Object)matchingTests, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount());
    }

    private Integer getEstimatedTotalStepCount() {
        return this.getStepCount() + this.estimatedUnimplementedStepCount();
    }

    private Integer estimatedUnimplementedStepCount() {
        return (int)Math.round(this.getAverageTestSize() * (double)this.totalUnimplementedTests());
    }

    public double getAverageTestSize() {
        if (this.totalImplementedTests() > 0) {
            return (double)this.getStepCount() / (double)this.totalImplementedTests();
        }
        return this.estimatedAverageStepCount;
    }

    private int totalUnimplementedTests() {
        return this.getTotal() - this.totalImplementedTests();
    }

    private int totalImplementedTests() {
        return Lambda.filter((Matcher)Lambda.having((Object)((TestOutcome)Lambda.on(TestOutcome.class)).getTestSteps().isEmpty(), (Matcher)Matchers.is((Object)false)), this.outcomes).size();
    }

    private class TagFinder {
        private final String tagType;

        private TagFinder(String tagType) {
            this.tagType = tagType;
        }

        List<String> in(TestOutcome testOutcome) {
            ArrayList matchingTags = Lists.newArrayList();
            for (TestTag tag : testOutcome.getTags()) {
                if (!tag.getType().equals(this.tagType)) continue;
                matchingTags.add(tag.getName());
            }
            return ImmutableList.copyOf((Collection)matchingTags);
        }
    }
}

