/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import net.thucydides.core.util.Inflector;

public class Inflection {
    private static final int DEFAULT_PLURAL_COUNT = 2;
    private final String word;
    private final int pluralCount;

    protected Inflection(String word) {
        this(word, 2);
    }

    protected Inflection(String word, int pluralCount) {
        this.word = word;
        this.pluralCount = pluralCount;
    }

    public String toString() {
        return this.word;
    }

    public Inflection inPluralForm() {
        return new Inflection(Inflector.getInstance().pluralize(this.word, this.pluralCount));
    }

    public Inflection inSingularForm() {
        return new Inflection(Inflector.getInstance().singularize(this.word));
    }

    public Inflection startingWithACapital() {
        return new Inflection(Inflector.getInstance().capitalize(this.word));
    }

    public Inflection inHumanReadableForm() {
        return new Inflection(Inflector.getInstance().humanize(this.word, new String[0]));
    }

    public Inflection asATitle() {
        return new Inflection(Inflector.getInstance().titleCase(this.word, new String[0]));
    }
}

