/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.integration.db;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.statistics.integration.db.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.hsqldb.HsqlException;
import org.hsqldb.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHSqldbServerDatabase
implements LocalDatabase {
    private static final String LOCALHOST = "127.0.0.1";
    private final EnvironmentVariables environmentVariables;
    private Server server;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalHSqldbServerDatabase.class);

    @Inject
    public LocalHSqldbServerDatabase(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public void start() {
        this.startServer();
    }

    @Override
    public void stop() {
        this.stopServer();
    }

    @Override
    public String getUrl() {
        return "jdbc:hsqldb:hsql://127.0.0.1:" + this.getPort() + "/" + this.getDatabaseName();
    }

    @Override
    public String getDriver() {
        return "org.hsqldb.jdbc.JDBCDriver";
    }

    @Override
    public String getUsername() {
        return "SA";
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public String getDialect() {
        return "org.hibernate.dialect.HSQLDialect";
    }

    private synchronized void startServer() {
        LOGGER.info("Starting local statistics database");
        this.server = new Server();
        this.server.setAddress(LOCALHOST);
        this.server.setDatabaseName(0, this.getDatabaseName());
        this.server.setDatabasePath(0, "file:" + this.getDatabasePath());
        this.server.setPort(this.getPort());
        this.server.setTrace(false);
        this.server.setLogWriter(null);
        this.server.setDaemon(true);
        this.server.start();
    }

    private synchronized void stopServer() {
        if (this.isAvailable()) {
            this.shutdownDatabase();
            this.server.stop();
        }
    }

    private void shutdownDatabase() {
        if (this.isAvailable()) {
            LOGGER.info("Shutting down local statistics database");
            try {
                Connection connection = DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
                connection.createStatement().executeUpdate("SHUTDOWN");
            }
            catch (SQLException e) {
                LOGGER.warn("Could not shut down local database");
            }
        }
    }

    public String getDatabaseName() {
        String projectKey = ThucydidesSystemProperty.PROJECT_KEY.from(this.environmentVariables, "default");
        return StringUtils.join((Iterable)ImmutableList.of((Object)"stats", (Object)projectKey), (String)"-");
    }

    public String getDatabasePath() {
        String defaultThucydidesDirectory = this.environmentVariables.getProperty("user.home") + "/.thucydides";
        String thucydidesHomeDirectory = ThucydidesSystemProperty.THUCYDIDES_HOME.from(this.environmentVariables, defaultThucydidesDirectory);
        return thucydidesHomeDirectory + "/" + this.getDatabaseName();
    }

    public int getPort() {
        return Integer.parseInt(ThucydidesSystemProperty.THUCYDIDES_PORT.from(this.environmentVariables, Integer.toString(9111)));
    }

    private boolean isRunningLocally() {
        boolean isRunning = false;
        if (this.server != null) {
            try {
                this.server.checkRunning(true);
                isRunning = true;
            }
            catch (HsqlException e) {
                isRunning = false;
            }
        }
        return isRunning;
    }

    @Override
    public boolean isAvailable() {
        return this.isRunningLocally() || this.isRunningElsewhere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunningElsewhere() {
        Socket socket = null;
        boolean available = true;
        try {
            socket = new Socket(InetAddress.getByName(LOCALHOST), this.getPort());
        }
        catch (IOException e) {
            available = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return available;
    }
}

