/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import net.thucydides.core.util.EnvironmentVariables;

public class SystemEnvironmentVariables
implements EnvironmentVariables {
    @Override
    public String getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public String getValue(String name, String defaultValue) {
        String value = System.getenv(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Integer getPropertyAsInteger(String property, Integer defaultValue) {
        String value = System.getProperty(property);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (System.getProperty(name) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(System.getProperty(name, "false"));
    }

    @Override
    public String getProperty(String name) {
        return System.getProperty(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        System.setProperty(name, value);
    }

    @Override
    public void clearProperty(String name) {
        System.clearProperty(name);
    }
}

