/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.database;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.sql.SQLException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalH2ServerDatabase
implements LocalDatabase {
    private final EnvironmentVariables environmentVariables;
    Server server;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalH2ServerDatabase.class);

    @Inject
    public LocalH2ServerDatabase(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public void start() {
        try {
            LOGGER.info("STARTING H2 DATABASE AT " + this.getUrl());
            this.server = Server.createTcpServer((String[])new String[]{"-tcpAllowOthers"}).start();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        LOGGER.info("SHUTTING DOWN H2 DATABASE");
        this.server.shutdown();
        this.server.stop();
    }

    @Override
    public boolean isAvailable() {
        return this.server != null && this.server.isRunning(false);
    }

    @Override
    public String getUrl() {
        return "jdbc:h2:tcp://localhost/" + this.getDatabasePath();
    }

    @Override
    public String getDriver() {
        return "org.h2.Driver";
    }

    @Override
    public String getUsername() {
        return "SA";
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public String getDialect() {
        return "org.hibernate.dialect.H2Dialect";
    }

    public String getDatabaseName() {
        String projectKey = ThucydidesSystemProperty.PROJECT_KEY.from(this.environmentVariables, "default");
        return StringUtils.join((Iterable)ImmutableList.of((Object)"stats", (Object)projectKey), (String)"-");
    }

    public String getDatabasePath() {
        String defaultThucydidesDirectory = this.environmentVariables.getProperty("user.home") + "/.thucydides";
        String thucydidesHomeDirectory = ThucydidesSystemProperty.THUCYDIDES_HOME.from(this.environmentVariables, defaultThucydidesDirectory);
        return thucydidesHomeDirectory + "/" + this.getDatabaseName();
    }
}

