/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.annotations.Issue;
import net.thucydides.core.annotations.Issues;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.annotations.WithTag;
import net.thucydides.core.annotations.WithTags;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.util.NameConverter;

public class TestAnnotations {
    private final Class<?> testClass;

    private TestAnnotations(Class<?> testClass) {
        this.testClass = testClass;
    }

    public static TestAnnotations forClass(Class<?> testClass) {
        return new TestAnnotations(testClass);
    }

    public Optional<String> getAnnotatedTitleForMethod(String methodName) {
        if (this.testClass != null && this.testClassHasMethodCalled(methodName)) {
            return this.getAnnotatedTitle(methodName);
        }
        return Optional.absent();
    }

    public boolean isPending(String methodName) {
        Optional<Method> method = this.getMethodCalled(methodName);
        return method.isPresent() && TestAnnotations.isPending((Method)method.get());
    }

    public static boolean isPending(Method method) {
        return method != null && method.getAnnotation(Pending.class) != null;
    }

    public static boolean isIgnored(Method method) {
        if (method != null) {
            return TestAnnotations.hasAnnotationCalled(method, "Ignore");
        }
        return false;
    }

    private static boolean hasAnnotationCalled(Method method, String annotationName) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!annotation.annotationType().getSimpleName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnored(String methodName) {
        Optional<Method> method = this.getMethodCalled(methodName);
        return method.isPresent() && TestAnnotations.isIgnored((Method)method.get());
    }

    private Optional<String> getAnnotatedTitle(String methodName) {
        Title titleAnnotation;
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && (titleAnnotation = ((Method)testMethod.get()).getAnnotation(Title.class)) != null) {
            return Optional.of((Object)titleAnnotation.value());
        }
        return Optional.absent();
    }

    private boolean testClassHasMethodCalled(String methodName) {
        return this.getMethodCalled(methodName).isPresent();
    }

    private Optional<Method> getMethodCalled(String methodName) {
        if (this.testClass == null) {
            return Optional.absent();
        }
        String baseMethodName = NameConverter.withNoArguments(methodName);
        try {
            if (baseMethodName == null) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)this.testClass.getMethod(baseMethodName, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
    }

    public List<String> getAnnotatedIssuesForMethodTitle(String methodName) {
        Optional<String> title = this.getAnnotatedTitleForMethod(methodName);
        if (title.isPresent()) {
            return Formatter.issuesIn((String)title.get());
        }
        return Formatter.issuesIn(methodName);
    }

    private Optional<String> getAnnotatedIssue(String methodName) {
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && ((Method)testMethod.get()).getAnnotation(Issue.class) != null) {
            return Optional.of((Object)((Method)testMethod.get()).getAnnotation(Issue.class).value());
        }
        return Optional.absent();
    }

    private String[] getAnnotatedIssues(String methodName) {
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && ((Method)testMethod.get()).getAnnotation(Issues.class) != null) {
            return ((Method)testMethod.get()).getAnnotation(Issues.class).value();
        }
        return new String[0];
    }

    public Optional<String> getAnnotatedIssueForMethod(String methodName) {
        return this.getAnnotatedIssue(methodName);
    }

    public String[] getAnnotatedIssuesForMethod(String methodName) {
        return this.getAnnotatedIssues(methodName);
    }

    public String getAnnotatedIssueForTestCase(Class<?> testCase) {
        Issue issueAnnotation = testCase.getAnnotation(Issue.class);
        if (issueAnnotation != null) {
            return issueAnnotation.value();
        }
        return null;
    }

    public String[] getAnnotatedIssuesForTestCase(Class<?> testCase) {
        Issues issueAnnotation = testCase.getAnnotation(Issues.class);
        if (issueAnnotation != null) {
            return issueAnnotation.value();
        }
        return null;
    }

    public List<String> getIssuesForMethod(String methodName) {
        ArrayList<String> issues = new ArrayList<String>();
        if (this.testClass != null) {
            this.addIssuesFromMethod(methodName, issues);
        } else {
            this.addIssuesFromTestScenarioName(methodName, issues);
        }
        return issues;
    }

    private void addIssuesFromTestScenarioName(String methodName, List<String> issues) {
        issues.addAll(this.getAnnotatedIssuesForMethodTitle(methodName));
    }

    private void addIssuesFromMethod(String methodName, List<String> issues) {
        if (this.getAnnotatedIssues(methodName) != null) {
            issues.addAll(Arrays.asList(this.getAnnotatedIssues(methodName)));
        }
        if (this.getAnnotatedIssue(methodName).isPresent()) {
            issues.add((String)this.getAnnotatedIssue(methodName).get());
        }
        if (this.getAnnotatedTitle(methodName) != null) {
            this.addIssuesFromTestScenarioName(methodName, issues);
        }
    }

    public List<WithTag> getTagsForMethod(String methodName) {
        ArrayList<WithTag> allTags = new ArrayList<WithTag>(this.getTags());
        allTags.addAll(this.getTagsFor(methodName));
        return ImmutableList.copyOf(allTags);
    }

    public List<WithTag> getTags() {
        ArrayList<WithTag> tags = new ArrayList<WithTag>();
        if (this.testClass != null) {
            this.addTags(tags, this.testClass.getAnnotation(WithTags.class));
            this.addTag(tags, this.testClass.getAnnotation(WithTag.class));
        }
        return tags;
    }

    private void addTag(List<WithTag> tags, WithTag tag) {
        if (tag != null) {
            tags.add(tag);
        }
    }

    private void addTags(List<WithTag> tags, WithTags tagSet) {
        if (tagSet != null) {
            tags.addAll(Arrays.asList(tagSet.value()));
        }
    }

    private List<WithTag> getTagsFor(String methodName) {
        ArrayList<WithTag> tags = new ArrayList<WithTag>();
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent()) {
            this.addTags(tags, ((Method)testMethod.get()).getAnnotation(WithTags.class));
            this.addTag(tags, ((Method)testMethod.get()).getAnnotation(WithTag.class));
        }
        return tags;
    }
}

