/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.thucydides.core.annotations.AnnotatedFields;
import net.thucydides.core.annotations.ManagedPages;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reflection.FieldSetter;
import net.thucydides.core.steps.InvalidManagedPagesFieldException;

public class PagesAnnotatedField {
    private static final String NO_ANNOTATED_FIELD_ERROR = "No Pages field annotated with @ManagedPages was found in the test case.";
    private Field field;
    private ManagedPages annotation;

    public static PagesAnnotatedField findFirstAnnotatedField(Class<?> testClass) {
        for (Field field : AnnotatedFields.of(testClass).allFields()) {
            ManagedPages fieldAnnotation = PagesAnnotatedField.annotationFrom(field);
            if (fieldAnnotation == null) continue;
            return new PagesAnnotatedField(field, fieldAnnotation);
        }
        throw new InvalidManagedPagesFieldException(NO_ANNOTATED_FIELD_ERROR);
    }

    private static ManagedPages annotationFrom(Field aField) {
        ManagedPages annotationOnField = null;
        if (PagesAnnotatedField.isFieldAnnotated(aField)) {
            annotationOnField = aField.getAnnotation(ManagedPages.class);
        }
        return annotationOnField;
    }

    private static boolean isFieldAnnotated(Field field) {
        return PagesAnnotatedField.fieldIsAnnotatedCorrectly(field) && PagesAnnotatedField.fieldIsRightType(field);
    }

    private static boolean fieldIsRightType(Field field) {
        return field.getType().isAssignableFrom(Pages.class);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        boolean pagesAnnotationFound = false;
        for (Annotation annotation : field.getAnnotations()) {
            if (!(annotation instanceof ManagedPages)) continue;
            pagesAnnotationFound = true;
            break;
        }
        return pagesAnnotationFound;
    }

    protected PagesAnnotatedField(Field field, ManagedPages annotation) {
        this.field = field;
        this.annotation = annotation;
    }

    public void setValue(Object testCase, Pages pages) {
        try {
            this.set(testCase).to(pages);
        }
        catch (IllegalAccessException e) {
            throw new InvalidManagedPagesFieldException("Could not access or set managed pages field: " + this.field, e);
        }
    }

    protected FieldSetter set(Object targetObject) {
        return new FieldSetter(this.field, targetObject);
    }

    public String getDefaultBaseUrl() {
        return this.annotation.defaultUrl();
    }
}

