/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.database;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class LocalHSQLDBDatabase
implements LocalDatabase {
    private final EnvironmentVariables environmentVariables;

    @Inject
    public LocalHSQLDBDatabase(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUrl() {
        return "jdbc:hsqldb:" + this.getDatabasePath() + ";shutdown=true";
    }

    @Override
    public String getDriver() {
        return "org.hsqldb.jdbc.JDBCDriver";
    }

    @Override
    public String getUsername() {
        return "sa";
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public String getDialect() {
        return "org.hibernate.dialect.HSQLDialect";
    }

    public String getDatabaseName() {
        String projectKey = ThucydidesSystemProperty.PROJECT_KEY.from(this.environmentVariables, "default");
        return StringUtils.join((Iterable)ImmutableList.of((Object)"stats", (Object)projectKey), (String)"-");
    }

    public String getDatabasePath() {
        String defaultThucydidesDirectory = this.environmentVariables.getProperty("user.home") + "/.thucydides";
        String thucydidesHomeDirectory = ThucydidesSystemProperty.THUCYDIDES_HOME.from(this.environmentVariables, defaultThucydidesDirectory);
        return thucydidesHomeDirectory + "/" + this.getDatabaseName();
    }
}

