/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Optional;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class ReportNameProvider {
    private final Optional<String> context;
    private final ReportNamer reportNamer = ReportNamer.forReportType(ReportType.HTML);

    public ReportNameProvider() {
        this.context = Optional.absent();
    }

    public ReportNameProvider(String context) {
        this.context = StringUtils.isEmpty((CharSequence)context) ? Optional.absent() : Optional.of((Object)context);
    }

    public String forTestResult(String result) {
        return this.prefixUsing(this.context) + "result_" + this.reportNamer.getNormalizedTestNameFor(result);
    }

    public String forTag(String tag) {
        return this.prefixUsing(this.context) + "tag_" + this.reportNamer.getNormalizedTestNameFor(tag);
    }

    public ReportNameProvider withPrefix(String prefix) {
        return new ReportNameProvider(prefix);
    }

    private String prefixUsing(Optional<String> context) {
        if (context.isPresent()) {
            return "context_" + NameConverter.underscore((String)context.get()) + "_";
        }
        return "";
    }

    public String forTagType(String tagType) {
        return "tagtype_" + this.reportNamer.getNormalizedTestNameFor(tagType);
    }

    public ReportNameProvider inContext(String context) {
        return new ReportNameProvider(context);
    }
}

