/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.screenshots.QueuedScreenshot;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.screenshots.ScreenshotSequence;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Photographer {
    private static final int MESSAGE_DIGEST_MASK = 255;
    private static final int PNG_SUFFIX_LENGTH = ".png".length();
    private final WebDriver driver;
    private final File targetDirectory;
    private final ScreenshotSequence screenshotSequence;
    private final MessageDigest digest;
    private final Logger logger = LoggerFactory.getLogger(Photographer.class);
    private ScreenshotProcessor screenshotProcessor;
    private static final ScreenshotSequence DEFAULT_SCREENSHOT_SEQUENCE = new ScreenshotSequence();

    protected Logger getLogger() {
        return this.logger;
    }

    public Photographer(WebDriver driver, File targetDirectory) {
        this.driver = driver;
        this.targetDirectory = targetDirectory;
        this.screenshotProcessor = (ScreenshotProcessor)Injectors.getInjector().getInstance(ScreenshotProcessor.class);
        this.screenshotSequence = DEFAULT_SCREENSHOT_SEQUENCE;
        this.digest = this.getMd5Digest();
    }

    private MessageDigest getMd5Digest() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().error("Failed to create digest for screenshot name.", (Throwable)e);
        }
        return md;
    }

    protected long nextScreenshotNumber() {
        return this.screenshotSequence.next();
    }

    private String nextScreenshotName(String prefix) {
        long nextScreenshotNumber = this.nextScreenshotNumber();
        return "screenshot-" + this.getMD5DigestFrom(prefix) + nextScreenshotNumber + ".png";
    }

    private String getMD5DigestFrom(String value) {
        byte[] messageDigest = this.digest.digest(value.getBytes());
        StringBuilder hexString = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            hexString.append(Integer.toHexString(0xFF & aMessageDigest));
        }
        return hexString.toString();
    }

    public File takeScreenshot(String prefix) {
        if (this.driverCanTakeSnapshots()) {
            try {
                byte[] screenshotData = (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
                Optional<File> savedScreenshot = this.saveScreenshotFile(screenshotData, prefix);
                this.savePageSourceFor(((File)savedScreenshot.get()).getAbsolutePath());
                return (File)savedScreenshot.get();
            }
            catch (Throwable e) {
                this.getLogger().warn("Failed to write screenshot (possibly an out of memory error): " + e.getMessage());
            }
        }
        return null;
    }

    private Optional<File> saveScreenshotFile(byte[] screenshotData, String prefix) throws IOException {
        if (screenshotData == null) {
            return Optional.absent();
        }
        this.targetDirectory.mkdirs();
        File savedScreenshot = new File(this.targetDirectory, this.nextScreenshotName(prefix));
        this.screenshotProcessor.queueScreenshot(new QueuedScreenshot(screenshotData, savedScreenshot));
        return Optional.of((Object)savedScreenshot);
    }

    protected boolean driverCanTakeSnapshots() {
        if (this.driver == null) {
            return false;
        }
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).canTakeScreenshots() && ((WebDriverFacade)this.driver).getProxiedDriver() != null;
        }
        return TakesScreenshot.class.isAssignableFrom(this.driver.getClass());
    }

    private void savePageSourceFor(String screenshotFile) throws IOException {
        try {
            WebDriver webdriver = this.driver;
            String pageSource = webdriver.getPageSource();
            File savedSource = new File(this.sourceCodeFileFor(screenshotFile));
            FileUtils.writeStringToFile((File)savedSource, (String)pageSource);
        }
        catch (WebDriverException e) {
            this.getLogger().warn("Failed to save screen source code", (Throwable)e);
        }
    }

    private String sourceCodeFileFor(String screenshotFile) {
        String rootFilename = screenshotFile.substring(0, screenshotFile.length() - PNG_SUFFIX_LENGTH);
        return rootFilename + ".html";
    }

    public File getMatchingSourceCodeFor(File screenshot) {
        if (screenshot != null) {
            return new File(this.sourceCodeFileFor(screenshot.getAbsolutePath()));
        }
        return null;
    }

    public void setScreenshotProcessor(ScreenshotProcessor screenshotProcessor) {
        this.screenshotProcessor = screenshotProcessor;
    }

    protected ScreenshotProcessor getScreenshotProcessor() {
        return this.screenshotProcessor;
    }
}

