/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.statistics.service.TagProvider;

public class FeatureStoryTagProvider
implements TagProvider {
    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet tags = Sets.newHashSet();
        this.addStoryTagIfPresent(testOutcome, tags);
        this.addFeatureTagIfPresent(testOutcome, tags);
        return ImmutableSet.copyOf((Collection)tags);
    }

    private void addStoryTagIfPresent(TestOutcome testOutcome, Set<TestTag> tags) {
        Story story = testOutcome.getUserStory();
        if (story != null) {
            tags.add(TestTag.withName(story.getName()).andType("story"));
        }
    }

    private void addFeatureTagIfPresent(TestOutcome testOutcome, Set<TestTag> tags) {
        ApplicationFeature feature = testOutcome.getFeature();
        if (feature != null) {
            tags.add(TestTag.withName(feature.getName()).andType("feature"));
        }
    }
}

