/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportNamer {
    private ReportType type;

    public static ReportNamer forReportType(ReportType type) {
        return new ReportNamer(type);
    }

    private ReportNamer(ReportType type) {
        this.type = type;
    }

    public String getNormalizedTestNameFor(TestOutcome testOutcome) {
        String testName = "";
        if (testOutcome.getUserStory() != null) {
            testName = NameConverter.underscore(testOutcome.getUserStory().getName());
        }
        String scenarioName = NameConverter.underscore(testOutcome.getMethodName());
        testName = NameConverter.withNoIssueNumbers(this.appendToIfNotNull(testName, scenarioName));
        return this.appendSuffixTo(testName);
    }

    public String getSimpleTestNameFor(TestOutcome testOutcome) {
        String testName = "";
        if (testOutcome.getUserStory() != null) {
            testName = NameConverter.underscore(testOutcome.getUserStory().getName());
        }
        String scenarioName = NameConverter.underscore(testOutcome.getMethodName());
        testName = NameConverter.withNoIssueNumbers(NameConverter.withNoArguments(this.appendToIfNotNull(testName, scenarioName)));
        return this.appendSuffixTo(testName);
    }

    private String appendToIfNotNull(String baseString, String nextElement) {
        if (StringUtils.isNotEmpty((CharSequence)baseString)) {
            return baseString + "_" + nextElement;
        }
        return nextElement;
    }

    public String getQualifiedTestNameFor(TestOutcome testOutcome, String qualifier) {
        String userStory = "";
        if (testOutcome.getUserStory() != null) {
            userStory = NameConverter.underscore(testOutcome.getUserStory().getName()) + "_";
        }
        String normalizedQualifier = qualifier.replaceAll(" ", "_");
        return this.appendSuffixTo(userStory + testOutcome.getMethodName() + "_" + normalizedQualifier);
    }

    public String getNormalizedTestNameFor(Story userStory) {
        return this.getNormalizedTestNameFor(userStory.getName());
    }

    public String getNormalizedTestNameFor(ApplicationFeature feature) {
        return this.getNormalizedTestNameFor(feature.getName());
    }

    public String getNormalizedTestNameFor(String name) {
        String testNameWithUnderscores = NameConverter.underscore(name);
        String nameWithSuffix = this.appendSuffixTo(testNameWithUnderscores);
        return DigestUtils.md5Hex((String)nameWithSuffix);
    }

    private String appendSuffixTo(String testNameWithUnderscores) {
        if (this.type == ReportType.ROOT) {
            return testNameWithUnderscores;
        }
        return testNameWithUnderscores + "." + this.type.toString();
    }
}

