/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.List;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.scheduling.NormalFluentWait;
import net.thucydides.core.scheduling.ThucydidesFluentWait;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RenderedPageObjectView {
    private final transient WebDriver driver;
    private transient long waitForTimeout;
    private final Clock webdriverClock;
    private final Sleeper sleeper;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderedPageObjectView.class);

    public RenderedPageObjectView(WebDriver driver, long waitForTimeout) {
        this.driver = driver;
        this.waitForTimeout = waitForTimeout;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
    }

    public ThucydidesFluentWait<WebDriver> waitForCondition() {
        return new NormalFluentWait<WebDriver>(this.driver, this.webdriverClock, this.sleeper).withTimeout(this.waitForTimeout, TimeUnit.MILLISECONDS).pollingEvery(50L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    private ExpectedCondition<Boolean> elementDisplayed(final By byElementCriteria) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementIsDisplayed(byElementCriteria);
            }
        };
    }

    private ExpectedCondition<Boolean> elementPresent(final By byElementCriteria) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementIsDisplayed(byElementCriteria);
            }
        };
    }

    public void waitFor(By byElementCriteria) {
        this.waitForCondition().until(this.elementDisplayed(byElementCriteria));
    }

    public void waitForPresenceOf(By byElementCriteria) {
        this.waitForCondition().until(this.elementPresent(byElementCriteria));
    }

    public boolean elementIsPresent(By byElementCriteria) {
        boolean isDisplayed = true;
        try {
            List matchingElements = this.driver.findElements(byElementCriteria);
            if (matchingElements.isEmpty()) {
                isDisplayed = false;
            }
        }
        catch (NoSuchElementException noSuchElement) {
            LOGGER.trace("No such element " + (Object)((Object)noSuchElement));
            isDisplayed = false;
        }
        return isDisplayed;
    }

    public boolean elementIsDisplayed(By byElementCriteria) {
        try {
            List matchingElements = this.driver.findElements(byElementCriteria);
            return this.matchingElementsArePresent(matchingElements) && ((WebElement)matchingElements.get(0)).isDisplayed();
        }
        catch (NoSuchElementException noSuchElement) {
            LOGGER.trace("No such element " + (Object)((Object)noSuchElement));
            return false;
        }
        catch (StaleElementReferenceException se) {
            LOGGER.trace("Element no longer attached to the DOM " + (Object)((Object)se));
            return false;
        }
    }

    private boolean matchingElementsArePresent(List<WebElement> matchingElements) {
        return matchingElements != null && !matchingElements.isEmpty();
    }

    private ExpectedCondition<Boolean> textPresent(final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.containsText(expectedText);
            }
        };
    }

    public void waitForText(String expectedText) {
        this.waitForCondition().until(this.textPresent(expectedText));
    }

    private ExpectedCondition<Boolean> textPresentInElement(final WebElement element, final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.containsText(element, expectedText);
            }
        };
    }

    public void waitForText(WebElement element, String expectedText) {
        this.waitForCondition().until(this.textPresentInElement(element, expectedText));
    }

    private ExpectedCondition<Boolean> titlePresent(final String expectedTitle) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.titleIs(expectedTitle);
            }
        };
    }

    public void waitForTitle(String expectedTitle) {
        this.waitForCondition().until(this.titlePresent(expectedTitle));
    }

    private boolean titleIs(String expectedTitle) {
        return this.driver.getTitle() != null && this.driver.getTitle().equals(expectedTitle);
    }

    public boolean containsText(String textValue) {
        String textInBody = String.format("//body[contains(.,\"%s\")]", textValue);
        List elements = this.driver.findElements(By.xpath((String)textInBody));
        return !this.foundNo(elements);
    }

    private boolean foundNo(List<WebElement> elements) {
        return elements == null || elements.isEmpty();
    }

    public boolean containsText(WebElement element, String textValue) {
        String textInBody = String.format("//body[contains(.,\"%s\")]", textValue);
        List elements = element.findElements(By.xpath((String)textInBody));
        return !this.foundNo(elements);
    }

    private ExpectedCondition<Boolean> textNotPresent(final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !RenderedPageObjectView.this.containsText(expectedText);
            }
        };
    }

    public void waitForTextToDisappear(String expectedText, long timeout) {
        this.waitForCondition().withTimeout(timeout, TimeUnit.MILLISECONDS).until(this.textNotPresent(expectedText));
    }

    private ExpectedCondition<Boolean> titleNotPresent(final String expectedTitle) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !RenderedPageObjectView.this.titleIs(expectedTitle);
            }
        };
    }

    public void waitForTitleToDisappear(String expectedTitle) {
        this.waitForCondition().until(this.titleNotPresent(expectedTitle));
    }

    private ExpectedCondition<Boolean> anyTextPresent(final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.pageContainsAny(expectedTexts);
            }
        };
    }

    public void waitForAnyTextToAppear(String ... expectedTexts) {
        this.waitForCondition().until(this.anyTextPresent(expectedTexts));
    }

    private ExpectedCondition<Boolean> anyTextPresentInElement(final WebElement element, final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementContains(element, expectedTexts);
            }
        };
    }

    public void waitForAnyTextToAppear(WebElement element, String ... expectedTexts) {
        this.waitForCondition().until(this.anyTextPresentInElement(element, expectedTexts));
    }

    private boolean elementContains(WebElement element, String ... expectedTexts) {
        for (String expectedText : expectedTexts) {
            if (!this.containsText(element, expectedText)) continue;
            return true;
        }
        return false;
    }

    private boolean pageContainsAny(String ... expectedTexts) {
        for (String expectedText : expectedTexts) {
            if (!this.containsText(expectedText)) continue;
            return true;
        }
        return false;
    }

    private ExpectedCondition<Boolean> allTextPresent(final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                for (String expectedText : expectedTexts) {
                    if (RenderedPageObjectView.this.containsText(expectedText)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public void waitForAllTextToAppear(String ... expectedTexts) {
        this.waitForCondition().until(this.allTextPresent(expectedTexts));
    }

    private ExpectedCondition<Boolean> elementNotDisplayed(final By byElementCriteria) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !RenderedPageObjectView.this.elementIsDisplayed(byElementCriteria);
            }
        };
    }

    public void waitForElementsToDisappear(By byElementCriteria) {
        this.waitForCondition().until(this.elementNotDisplayed(byElementCriteria));
    }

    private ExpectedCondition<Boolean> anyElementPresent(final By ... expectedElements) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                for (By expectedElement : expectedElements) {
                    if (!RenderedPageObjectView.this.elementIsDisplayed(expectedElement)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public void waitForAnyRenderedElementOf(By[] expectedElements) {
        this.waitForCondition().until(this.anyElementPresent(expectedElements));
    }

    public void setWaitForTimeout(long waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
    }
}

