/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.xml.TestOutcomeConverter;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTestOutcomeReporter
implements AcceptanceTestReporter {
    private File outputDirectory;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLTestOutcomeReporter.class);
    private transient String qualifier;

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void setResourceDirectory(String resourceDirectoryPath) {
    }

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome) throws IOException {
        LOGGER.debug("Generating XML report for {}/{}", (Object)testOutcome.getUserStory(), (Object)testOutcome.getMethodName());
        LOGGER.debug("Test outcome contents = {}", (Object)testOutcome);
        Preconditions.checkNotNull((Object)this.outputDirectory);
        XStream xstream = new XStream();
        xstream.alias("acceptance-test-run", TestOutcome.class);
        xstream.registerConverter((Converter)this.usingXmlConverter());
        String xmlContents = xstream.toXML((Object)testOutcome);
        String reportFilename = this.reportFor(testOutcome);
        LOGGER.debug("Calculated report filename: {}", (Object)reportFilename);
        File report = new File(this.getOutputDirectory(), reportFilename);
        LOGGER.debug("Writing XML report to {}", (Object)report.getAbsolutePath());
        FileUtils.writeStringToFile((File)report, (String)xmlContents);
        return report;
    }

    private TestOutcomeConverter usingXmlConverter() {
        if (this.qualifier == null) {
            return new TestOutcomeConverter();
        }
        return new TestOutcomeConverter(this.qualifier);
    }

    private String reportFor(TestOutcome testOutcome) {
        if (this.qualifier == null) {
            return testOutcome.getReportName(ReportType.XML);
        }
        return testOutcome.getReportName(ReportType.XML, this.qualifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TestOutcome> loadReportFrom(File reportFile) throws IOException {
        InputStream input = null;
        try {
            XStream xstream = new XStream();
            xstream.alias("acceptance-test-run", TestOutcome.class);
            xstream.registerConverter((Converter)this.usingXmlConverter());
            input = new FileInputStream(reportFile);
            Optional optional = Optional.of((Object)((TestOutcome)xstream.fromXML(input)));
            return optional;
        }
        catch (CannotResolveClassException e) {
            LOGGER.warn("Tried to load a file that is not a thucydides report: " + reportFile);
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            input.close();
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

