/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import net.thucydides.core.matchers.BeanCountMatcher;
import net.thucydides.core.matchers.BeanMatcher;
import net.thucydides.core.matchers.BeanPropertyMatcher;
import net.thucydides.core.matchers.BeanUniquenessMatcher;
import net.thucydides.core.matchers.MaxFieldValueMatcher;
import net.thucydides.core.matchers.MinFieldValueMatcher;
import net.thucydides.core.matchers.SimpleValueMatcher;
import org.hamcrest.Matcher;

public class BeanMatchers {
    public static BeanMatcher the(String fieldName, Matcher<? extends Object> matcher) {
        return new BeanPropertyMatcher(fieldName, matcher);
    }

    public static BeanMatcher the_count(Matcher<Integer> countMatcher) {
        return new BeanCountMatcher(countMatcher);
    }

    public static BeanConstraint each(String fieldName) {
        return new BeanConstraint(fieldName);
    }

    public static BeanMatcher max(String fieldName, Matcher<? extends Comparable> valueMatcher) {
        return new MaxFieldValueMatcher(fieldName, valueMatcher);
    }

    public static BeanMatcher min(String fieldName, Matcher<? extends Comparable> valueMatcher) {
        return new MinFieldValueMatcher(fieldName, valueMatcher);
    }

    public static SimpleValueMatcher checkThat(String value, Matcher<? extends Object> matcher) {
        return new SimpleValueMatcher(value, matcher);
    }

    public static class BeanConstraint {
        private final String fieldName;

        public BeanConstraint(String fieldName) {
            this.fieldName = fieldName;
        }

        public BeanMatcher isDifferent() {
            return new BeanUniquenessMatcher(this.fieldName);
        }
    }
}

