/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.features;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.FeatureResults;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.model.userstories.UserStoryLoader;

public class FeatureLoader {
    private UserStoryLoader userStoriesLoader = new UserStoryLoader();

    public void setUserStoriesLoader(UserStoryLoader userStoriesLoader) {
        this.userStoriesLoader = userStoriesLoader;
    }

    public UserStoryLoader getUserStoriesLoader() {
        return this.userStoriesLoader;
    }

    public List<FeatureResults> loadFrom(File resultsDirectory) throws IOException {
        ArrayList<FeatureResults> results = new ArrayList<FeatureResults>();
        List<StoryTestResults> stories = this.getUserStoriesLoader().loadFrom(resultsDirectory);
        for (StoryTestResults storyResult : stories) {
            this.updateFeatureResults(results, storyResult);
        }
        return results;
    }

    private void updateFeatureResults(List<FeatureResults> results, StoryTestResults storyResult) {
        ApplicationFeature feature = storyResult.getStory().getFeature();
        if (feature != null) {
            FeatureResults featureResults = this.featureResultsFor(feature, results);
            featureResults.recordStoryResults(storyResult);
        }
    }

    private FeatureResults featureResultsFor(ApplicationFeature feature, List<FeatureResults> results) {
        FeatureResults matchingFeatureResults = null;
        for (FeatureResults featureResult : results) {
            if (!featureResult.getFeature().equals(feature)) continue;
            matchingFeatureResults = featureResult;
            break;
        }
        if (matchingFeatureResults == null) {
            matchingFeatureResults = new FeatureResults(feature);
            results.add(matchingFeatureResults);
        }
        return matchingFeatureResults;
    }
}

