/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.inject.Inject;
import java.io.File;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertiesConfiguration
implements Configuration {
    public static final String WEBDRIVER_DRIVER = ThucydidesSystemProperty.DRIVER.getPropertyName();
    public static final String DEFAULT_WEBDRIVER_DRIVER = "firefox";
    public static final int DEFAULT_ELEMENT_TIMEOUT_SECONDS = 5;
    public final Integer DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT = 5;
    private String defaultBaseUrl;
    public static final String OUTPUT_DIRECTORY_PROPERTY = ThucydidesSystemProperty.OUTPUT_DIRECTORY.getPropertyName();
    private static final String MAVEN_BUILD_DIRECTORY = "project.build.directory";
    private static final String MAVEN_REPORTS_DIRECTORY = "project.reporting.OutputDirectory";
    public static final String ASSUME_UNTRUSTED_CERTIFICATE_ISSUER = ThucydidesSystemProperty.ASSUME_UNTRUSTED_CERTIFICATE_ISSUER.getPropertyName();
    private static final String DEFAULT_OUTPUT_DIRECTORY = "target/site/thucydides";
    private File outputDirectory;
    private EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropertiesConfiguration.class);

    @Inject
    public SystemPropertiesConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        }
        return this.environmentVariables;
    }

    @Override
    public SupportedWebDriver getDriverType() {
        String driverType = this.getEnvironmentVariables().getProperty(WEBDRIVER_DRIVER, DEFAULT_WEBDRIVER_DRIVER);
        return this.lookupSupportedDriverTypeFor(driverType);
    }

    @Override
    public File loadOutputDirectoryFromSystemProperties() {
        String defaultMavenRelativeTargetDirectory = this.getMavenBuildDirectory();
        String systemDefinedDirectory = this.getEnvironmentVariables().getProperty(OUTPUT_DIRECTORY_PROPERTY, defaultMavenRelativeTargetDirectory);
        if (systemDefinedDirectory == null) {
            systemDefinedDirectory = DEFAULT_OUTPUT_DIRECTORY;
        }
        return new File(systemDefinedDirectory);
    }

    private String getMavenBuildDirectory() {
        String mavenBuildDirectory = this.getEnvironmentVariables().getProperty(MAVEN_BUILD_DIRECTORY);
        String mavenReportsDirectory = this.getEnvironmentVariables().getProperty(MAVEN_REPORTS_DIRECTORY);
        String defaultMavenRelativeTargetDirectory = null;
        if (StringUtils.isNotEmpty((String)mavenReportsDirectory)) {
            defaultMavenRelativeTargetDirectory = mavenReportsDirectory + "/thucydides";
        } else if (StringUtils.isNotEmpty((String)mavenBuildDirectory)) {
            defaultMavenRelativeTargetDirectory = mavenBuildDirectory + "/site/thucydides";
        }
        return defaultMavenRelativeTargetDirectory;
    }

    @Override
    public int getStepDelay() {
        int stepDelay = 0;
        String stepDelayValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.STEP_DELAY.getPropertyName());
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            stepDelay = Integer.valueOf(stepDelayValue);
        }
        return stepDelay;
    }

    @Override
    public int getElementTimeout() {
        int elementTimeout = 5;
        String stepDelayValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.ELEMENT_TIMEOUT.getPropertyName());
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            elementTimeout = Integer.valueOf(stepDelayValue);
        }
        return elementTimeout;
    }

    @Override
    public boolean getUseUniqueBrowser() {
        boolean uniqueBrowser = false;
        String uniqueBrowserValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.UNIQUE_BROWSER.getPropertyName());
        if (uniqueBrowserValue != null) {
            uniqueBrowser = Boolean.valueOf(uniqueBrowserValue);
        }
        return uniqueBrowser;
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public File getOutputDirectory() {
        this.outputDirectory = this.loadOutputDirectoryFromSystemProperties();
        this.outputDirectory.mkdirs();
        LOGGER.info("Writing reports to " + this.outputDirectory);
        return this.outputDirectory;
    }

    @Override
    public double getEstimatedAverageStepCount() {
        return this.getEnvironmentVariables().getPropertyAsInteger(ThucydidesSystemProperty.ESTIMATED_AVERAGE_STEP_COUNT.getPropertyName(), this.DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT).intValue();
    }

    @Override
    public boolean onlySaveFailingScreenshots() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.ONLY_SAVE_FAILING_SCREENSHOTS.getPropertyName(), false);
    }

    @Override
    public boolean takeVerboseScreenshots() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.VERBOSE_SCREENSHOTS.getPropertyName(), true);
    }

    @Override
    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    @Override
    public int getRestartFrequency() {
        return this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.RESTART_BROWSER_FREQUENCY.getPropertyName(), (Integer)0);
    }

    @Override
    public String getBaseUrl() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.BASE_URL.getPropertyName(), this.defaultBaseUrl);
    }

    private SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.getDriverTypeFor(driverType);
        }
        catch (IllegalArgumentException iae) {
            this.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new UnsupportedDriverException(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }
}

