/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.inject.Inject;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.logging.LoggingLevel;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleLoggingListener
implements StepListener {
    private static final String BANNER = "\n\n-------------------------------------------------------------------------------------------------------\n.___________. __    __   __    __    ______ ____    ____  _______   __   _______   _______     _______.\n|           ||  |  |  | |  |  |  |  /      |\\   \\  /   / |       \\ |  | |       \\ |   ____|   /       |\n`---|  |----`|  |__|  | |  |  |  | |  ,----' \\   \\/   /  |  .--.  ||  | |  .--.  ||  |__     |   (----`\n    |  |     |   __   | |  |  |  | |  |       \\_    _/   |  |  |  ||  | |  |  |  ||   __|     \\   \\    \n    |  |     |  |  |  | |  `--'  | |  `----.    |  |     |  '--'  ||  | |  '--'  ||  |____.----)   |   \n    |__|     |__|  |__|  \\______/   \\______|    |__|     |_______/ |__| |_______/ |_______|_______/    \n                                                                                                       \n-------------------------------------------------------------------------------------------------------\n";
    private static final String TEST_STARTED = "\n  _____ _____ ____ _____   ____ _____  _    ____ _____ _____ ____  \n |_   _| ____/ ___|_   _| / ___|_   _|/ \\  |  _ \\_   _| ____|  _ \\ \n   | | |  _| \\___ \\ | |   \\___ \\ | | / _ \\ | |_) || | |  _| | | | |\n   | | | |___ ___) || |    ___) || |/ ___ \\|  _ < | | | |___| |_| |\n   |_| |_____|____/ |_|   |____/ |_/_/   \\_\\_| \\_\\|_| |_____|____/ \n                                                                   \n";
    private static final String TEST_PASSED = "\n        __    _____ _____ ____ _____   ____   _    ____  ____  _____ ____  \n  _     \\ \\  |_   _| ____/ ___|_   _| |  _ \\ / \\  / ___|/ ___|| ____|  _ \\ \n (_)_____| |   | | |  _| \\___ \\ | |   | |_) / _ \\ \\___ \\\\___ \\|  _| | | | |\n  _|_____| |   | | | |___ ___) || |   |  __/ ___ \\ ___) |___) | |___| |_| |\n (_)     | |   |_| |_____|____/ |_|   |_| /_/   \\_\\____/|____/|_____|____/ \n        /_/                                                                \n";
    private static final String TEST_FAILED = "\n           __  _____ _____ ____ _____   _____ _    ___ _     _____ ____  \n  _       / / |_   _| ____/ ___|_   _| |  ___/ \\  |_ _| |   | ____|  _ \\ \n (_)_____| |    | | |  _| \\___ \\ | |   | |_ / _ \\  | || |   |  _| | | | |\n  _|_____| |    | | | |___ ___) || |   |  _/ ___ \\ | || |___| |___| |_| |\n (_)     | |    |_| |_____|____/ |_|   |_|/_/   \\_\\___|_____|_____|____/ \n          \\_\\                                                            \n";
    private static final String TEST_SKIPPED = "\n            __  _____ _____ ____ _____   ____  _  _____ ____  ____  _____ ____  \n  _        / / |_   _| ____/ ___|_   _| / ___|| |/ /_ _|  _ \\|  _ \\| ____|  _ \\ \n (_)_____ / /    | | |  _| \\___ \\ | |   \\___ \\| ' / | || |_) | |_) |  _| | | | |\n  _|_____/ /     | | | |___ ___) || |    ___) | . \\ | ||  __/|  __/| |___| |_| |\n (_)    /_/      |_| |_____|____/ |_|   |____/|_|\\_\\___|_|   |_|   |_____|____/ \n                                                                                \n";
    private static final String FAILURE = "\n  _____ _    ___ _     _   _ ____  _____ \n |  ___/ \\  |_ _| |   | | | |  _ \\| ____|\n | |_ / _ \\  | || |   | | | | |_) |  _|  \n |  _/ ___ \\ | || |___| |_| |  _ <| |___ \n |_|/_/   \\_\\___|_____|\\___/|_| \\_\\_____|\n                                         \n";
    private final Logger logger;
    private final EnvironmentVariables environmentVariables;

    public ConsoleLoggingListener(EnvironmentVariables environmentVariables, Logger logger) {
        this.logger = logger;
        this.environmentVariables = environmentVariables;
        this.logBanner();
    }

    @Inject
    public ConsoleLoggingListener(EnvironmentVariables environmentVariables) {
        this(environmentVariables, LoggerFactory.getLogger(Thucydides.class));
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private void logBanner() {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info(BANNER);
        }
    }

    private boolean loggingLevelIsAtLeast(LoggingLevel minimumLoggingLevel) {
        return this.getLoggingLevel().compareTo(minimumLoggingLevel) >= 0;
    }

    private LoggingLevel getLoggingLevel() {
        String logLevel = ThucydidesSystemProperty.LOGGING.from(this.environmentVariables, LoggingLevel.NORMAL.name());
        return LoggingLevel.valueOf(logLevel);
    }

    @Override
    public void testSuiteStarted(Class<?> storyClass) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("Test Suite Started: " + NameConverter.humanize(storyClass.getSimpleName()));
        }
    }

    @Override
    public void testSuiteStarted(Story story) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("Test Suite Started: " + NameConverter.humanize(story.getName()));
        }
    }

    @Override
    public void testSuiteFinished() {
    }

    @Override
    public void testStarted(String description) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("\n  _____ _____ ____ _____   ____ _____  _    ____ _____ _____ ____  \n |_   _| ____/ ___|_   _| / ___|_   _|/ \\  |  _ \\_   _| ____|  _ \\ \n   | | |  _| \\___ \\ | |   \\___ \\ | | / _ \\ | |_) || | |  _| | | | |\n   | | | |___ ___) || |    ___) || |/ ___ \\|  _ < | | | |___| |_| |\n   |_| |_____|____/ |_|   |____/ |_/_/   \\_\\_| \\_\\|_| |_____|____/ \n                                                                   \n\nTEST: " + description + this.underline(TEST_STARTED));
        }
    }

    private String underline(String banner) {
        StringBuilder underline = new StringBuilder();
        int endOfLine = banner.indexOf(10, 1);
        if (endOfLine >= 0) {
            underline.append(StringUtils.repeat((char)'-', (int)endOfLine));
        } else {
            underline.append(StringUtils.repeat((char)'-', (int)banner.length()));
        }
        return "\n" + underline.toString();
    }

    @Override
    public void testFinished(TestOutcome result) {
        if (result.isFailure().booleanValue()) {
            this.logFailure(result);
        } else if (result.isPending().booleanValue()) {
            this.logPending(result);
        } else if (result.isSkipped().booleanValue()) {
            this.logSkipped(result);
        } else if (result.isSuccess().booleanValue()) {
            this.logSuccess(result);
        }
    }

    private void logFailure(TestOutcome result) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("\n           __  _____ _____ ____ _____   _____ _    ___ _     _____ ____  \n  _       / / |_   _| ____/ ___|_   _| |  ___/ \\  |_ _| |   | ____|  _ \\ \n (_)_____| |    | | |  _| \\___ \\ | |   | |_ / _ \\  | || |   |  _| | | | |\n  _|_____| |    | | | |___ ___) || |   |  _/ ___ \\ | || |___| |___| |_| |\n (_)     | |    |_| |_____|____/ |_|   |_|/_/   \\_\\___|_____|_____|____/ \n          \\_\\                                                            \n\nTEST: " + result.getTitle() + " failed" + this.underline(TEST_FAILED));
            if (result.getTestFailureCause() != null) {
                this.getLogger().info("\n  _____ _    ___ _     _   _ ____  _____ \n |  ___/ \\  |_ _| |   | | | |  _ \\| ____|\n | |_ / _ \\  | || |   | | | | |_) |  _|  \n |  _/ ___ \\ | || |___| |_| |  _ <| |___ \n |_|/_/   \\_\\___|_____|\\___/|_| \\_\\_____|\n                                         \n\n" + result.getTestFailureCause().getMessage());
            }
            this.underline(FAILURE);
        }
    }

    private void logPending(TestOutcome result) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("\n            __  _____ _____ ____ _____   ____  _  _____ ____  ____  _____ ____  \n  _        / / |_   _| ____/ ___|_   _| / ___|| |/ /_ _|  _ \\|  _ \\| ____|  _ \\ \n (_)_____ / /    | | |  _| \\___ \\ | |   \\___ \\| ' / | || |_) | |_) |  _| | | | |\n  _|_____/ /     | | | |___ ___) || |    ___) | . \\ | ||  __/|  __/| |___| |_| |\n (_)    /_/      |_| |_____|____/ |_|   |____/|_|\\_\\___|_|   |_|   |_____|____/ \n                                                                                \n\nTEST: " + result.getTitle() + " is pending" + this.underline(TEST_SKIPPED));
        }
    }

    private void logSkipped(TestOutcome result) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("\n            __  _____ _____ ____ _____   ____  _  _____ ____  ____  _____ ____  \n  _        / / |_   _| ____/ ___|_   _| / ___|| |/ /_ _|  _ \\|  _ \\| ____|  _ \\ \n (_)_____ / /    | | |  _| \\___ \\ | |   \\___ \\| ' / | || |_) | |_) |  _| | | | |\n  _|_____/ /     | | | |___ ___) || |    ___) | . \\ | ||  __/|  __/| |___| |_| |\n (_)    /_/      |_| |_____|____/ |_|   |____/|_|\\_\\___|_|   |_|   |_____|____/ \n                                                                                \n\nTEST: " + result.getTitle() + " is skipped" + this.underline(TEST_SKIPPED));
        }
    }

    private void logSuccess(TestOutcome result) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("\n        __    _____ _____ ____ _____   ____   _    ____  ____  _____ ____  \n  _     \\ \\  |_   _| ____/ ___|_   _| |  _ \\ / \\  / ___|/ ___|| ____|  _ \\ \n (_)_____| |   | | |  _| \\___ \\ | |   | |_) / _ \\ \\___ \\\\___ \\|  _| | | | |\n  _|_____| |   | | | |___ ___) || |   |  __/ ___ \\ ___) |___) | |___| |_| |\n (_)     | |   |_| |_____|____/ |_|   |_| /_/   \\_\\____/|____/|_____|____/ \n        /_/                                                                \n\nTEST: " + result.getTitle() + " passed" + this.underline(TEST_PASSED));
        }
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("STARTING STEP " + description.getTitle());
        }
    }

    @Override
    public void skippedStepStarted(ExecutedStepDescription description) {
        this.stepStarted(description);
    }

    @Override
    public void stepFinished() {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("FINISHING STEP");
        }
    }

    @Override
    public void stepFailed(StepFailure failure) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("STEP FAILED: " + failure.getMessage());
        }
    }

    @Override
    public void lastStepFailed(StepFailure failure) {
    }

    @Override
    public void stepIgnored() {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("IGNORING STEP");
        }
    }

    @Override
    public void stepIgnored(String message) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("IGNORING STEP (" + message + ")");
        }
    }

    @Override
    public void stepPending() {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("PENDING STEP");
        }
    }

    @Override
    public void stepPending(String message) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("PENDING STEP (" + message + ")");
        }
    }

    @Override
    public void testFailed(TestOutcome testOutcome, Throwable cause) {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            // empty if block
        }
    }

    @Override
    public void testIgnored() {
        this.getLoggingLevel();
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("TEST IGNORED");
        }
    }

    @Override
    public void notifyScreenChange() {
    }
}

