/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.annotations.WithTag;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.statistics.service.TagProvider;

public class AnnotationBasedTagProvider
implements TagProvider {
    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        if (testOutcome.getTestCase() == null) {
            return Collections.emptySet();
        }
        List<WithTag> tags = TestAnnotations.forClass(testOutcome.getTestCase()).getTagsForMethod(testOutcome.getMethodName());
        return Sets.newHashSet((Iterable)Lambda.convert(tags, this.toTestTags()));
    }

    private Converter<Object, TestTag> toTestTags() {
        return new Converter<Object, TestTag>(){

            public TestTag convert(Object tag) {
                WithTag withTag = (WithTag)tag;
                return TestTag.withName(withTag.name()).andType(withTag.type());
            }
        };
    }
}

