/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.inject.Key;
import java.io.File;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.logging.ThucydidesLogging;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.statistics.Statistics;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepListener;

public class Listeners {
    public static BaseStepListenerBuilder getBaseStepListener() {
        return new BaseStepListenerBuilder();
    }

    public static StepListener getLoggingListener() {
        return (StepListener)Injectors.getInjector().getInstance(Key.get(StepListener.class, ThucydidesLogging.class));
    }

    public static StepListener getStatisticsListener() {
        return (StepListener)Injectors.getInjector().getInstance(Key.get(StepListener.class, Statistics.class));
    }

    public static class BaseStepListenerBuilder {
        private Pages pages;

        public BaseStepListenerBuilder and() {
            return this;
        }

        public BaseStepListenerBuilder withPages(Pages pages) {
            this.pages = pages;
            return this;
        }

        public BaseStepListener withOutputDirectory(File outputDirectory) {
            if (this.pages != null) {
                return new BaseStepListener(outputDirectory, this.pages);
            }
            return new BaseStepListener(outputDirectory);
        }
    }
}

