/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.thucydides.core.resources.ResourceCopyingError;

public class ResourceList {
    private static final List<String> UNREQUIRED_FILES = Arrays.asList("pom.xml");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private final Pattern pattern;

    public static ResourceList forResources(Pattern pattern) {
        return new ResourceList(pattern);
    }

    protected ResourceList(Pattern pattern) {
        this.pattern = pattern;
    }

    public Collection<String> list() {
        String[] classPathElements;
        ArrayList<String> resources = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(PATH_SEPARATOR)) {
            resources.addAll(this.getResources(element, this.pattern));
        }
        return resources;
    }

    private Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> resources = new ArrayList<String>();
        File file = new File(element);
        if (this.isAJarFile(file)) {
            resources.addAll(this.getResourcesFromJarFile(file, pattern));
        } else {
            resources.addAll(this.getResourcesFromDirectory(file, pattern));
        }
        return this.removeUnnecessaryFilesFrom(resources);
    }

    private Collection<String> removeUnnecessaryFilesFrom(Collection<String> resources) {
        ArrayList<String> cleanedResources = new ArrayList<String>();
        for (String filepath : resources) {
            String filename = new File(filepath).getName();
            if (UNREQUIRED_FILES.contains(filename)) continue;
            cleanedResources.add(filepath);
        }
        return cleanedResources;
    }

    private boolean isAJarFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().endsWith(".jar");
    }

    protected ZipFile zipFileFor(File file) throws IOException {
        return new ZipFile(file);
    }

    private Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        if (file.exists()) {
            ZipFile zf;
            try {
                zf = this.zipFileFor(file);
            }
            catch (IOException e) {
                throw new ResourceCopyingError("Could not read from the JAR file", e);
            }
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String fileName = ze.getName();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                retval.add(fileName);
            }
            try {
                zf.close();
            }
            catch (IOException e1) {
                throw new ResourceCopyingError("Couldn't close the zip file", e1);
            }
        }
        return retval;
    }

    private Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory() && file.exists()) {
                    retval.addAll(this.getResourcesFromDirectory(file, pattern));
                    continue;
                }
                if (!file.exists()) continue;
                try {
                    String fileName = file.getCanonicalPath();
                    boolean accept = pattern.matcher(fileName).matches();
                    if (!accept) continue;
                    retval.add(fileName);
                }
                catch (IOException e) {
                    throw new ResourceCopyingError("Could not read from the JAR file", e);
                }
            }
        }
        return retval;
    }
}

