/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.guice;

import com.google.inject.Inject;
import java.util.Properties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.DatabaseConfig;
import net.thucydides.core.jpa.JPAProviderConfig;
import net.thucydides.core.jpa.JPAProviderConfigFactory;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;

public class EnvironmentVariablesDatabaseConfig
implements DatabaseConfig {
    private static final int TABLE_NAME_COLUMN = 3;
    private final EnvironmentVariables environmentVariables;
    private final LocalDatabase localDatabase;
    private final JPAProviderConfig providerConfig;
    private boolean isActive = true;

    @Inject
    public EnvironmentVariablesDatabaseConfig(EnvironmentVariables environmentVariables, LocalDatabase localDatabase) {
        this.environmentVariables = environmentVariables;
        this.localDatabase = localDatabase;
        this.providerConfig = JPAProviderConfigFactory.getJPAProviderConfig(environmentVariables, localDatabase);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        String driver = this.environmentVariables.getProperty("thucydides.statistics.driver_class", this.localDatabase.getDriver());
        properties.put(ThucydidesSystemProperty.JPA_PROVIDER.getPropertyName(), ThucydidesSystemProperty.JPA_PROVIDER.from(this.environmentVariables, JPAProviderConfigFactory.DEFAULT_PROVIDER.name()));
        this.providerConfig.setProperties(properties);
        return properties;
    }

    @Override
    public boolean isUsingLocalDatabase() {
        return this.providerConfig.isUsingLocalDatabase();
    }

    private boolean isStatisticsDisabled() {
        return Boolean.valueOf(this.environmentVariables.getProperty(ThucydidesSystemProperty.RECORD_STATISTICS, "true")) == false;
    }

    @Override
    public void disable() {
        this.isActive = false;
    }

    @Override
    public void enable() {
        this.isActive = true;
    }

    @Override
    public boolean isActive() {
        return this.isActive && !this.isStatisticsDisabled();
    }
}

