/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.jpa;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import net.thucydides.core.jpa.AbstractJPAProviderConfig;
import net.thucydides.core.jpa.JPAProvider;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;

public class EclipseLinkEnvironmentVariablesConfig
extends AbstractJPAProviderConfig {
    private final EnvironmentVariables environmentVariables;
    private final LocalDatabase localDatabase;
    private static final JPAProvider PROVIDER = JPAProvider.EclipseLink;

    @Inject
    public EclipseLinkEnvironmentVariablesConfig(EnvironmentVariables environmentVariables, LocalDatabase localDatabase) {
        this.environmentVariables = environmentVariables;
        this.localDatabase = localDatabase;
    }

    @Override
    public void setProperties(Properties properties) {
        String driver = this.environmentVariables.getProperty("thucydides.statistics.driver_class", this.localDatabase.getDriver());
        String url = this.environmentVariables.getProperty("thucydides.statistics.url", this.localDatabase.getUrl());
        String username = this.environmentVariables.getProperty("thucydides.statistics.username", this.localDatabase.getUsername());
        String password = this.environmentVariables.getProperty("thucydides.statistics.password", this.localDatabase.getPassword());
        String dialect = this.environmentVariables.getProperty("thucydides.statistics.dialect", "Auto");
        properties.put("javax.persistence.jdbc.driver", driver);
        properties.put("javax.persistence.jdbc.url", url);
        properties.put("javax.persistence.jdbc.user", username);
        properties.put("javax.persistence.jdbc.password", password);
        properties.put("eclipselink.target-database", dialect);
        properties.put("eclipselink.connection-pool.default.initial", "1");
        properties.put("eclipselink.connection-pool.default.max", "10");
        boolean databaseIsConfigured = this.databaseIsConfigured(properties);
        if (this.isUsingLocalDatabase() || !databaseIsConfigured) {
            properties.put("eclipselink.ddl-generation", "create-or-extend-tables");
        } else {
            properties.put("eclipselink.ddl-generation", "none");
        }
    }

    private boolean databaseIsConfigured(Properties targetConfiguration) {
        Properties connectionProps = new Properties();
        connectionProps.put("user", targetConfiguration.getProperty("javax.persistence.jdbc.user"));
        connectionProps.put("password", targetConfiguration.getProperty("javax.persistence.jdbc.password"));
        String jdbcConnection = targetConfiguration.getProperty("javax.persistence.jdbc.url");
        try {
            Connection conn = DriverManager.getConnection(jdbcConnection, connectionProps);
            List<String> tables = this.getTablesFrom(conn);
            return tables.contains("TESTRUN");
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean isUsingLocalDatabase() {
        return this.isUsingLocalDatabase(this.environmentVariables);
    }

    @Override
    public JPAProvider getProvider() {
        return PROVIDER;
    }
}

