/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.jpa;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import net.thucydides.core.jpa.AbstractJPAProviderConfig;
import net.thucydides.core.jpa.JPAProvider;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;

public class HibernateEnvironmentVariablesConfig
extends AbstractJPAProviderConfig {
    private final EnvironmentVariables environmentVariables;
    private final LocalDatabase localDatabase;
    private static final JPAProvider PROVIDER = JPAProvider.Hibernate;

    @Inject
    public HibernateEnvironmentVariablesConfig(EnvironmentVariables environmentVariables, LocalDatabase localDatabase) {
        this.environmentVariables = environmentVariables;
        this.localDatabase = localDatabase;
    }

    @Override
    public void setProperties(Properties properties) {
        String driver = this.environmentVariables.getProperty("thucydides.statistics.driver_class", this.localDatabase.getDriver());
        String url = this.environmentVariables.getProperty("thucydides.statistics.url", this.localDatabase.getUrl());
        String username = this.environmentVariables.getProperty("thucydides.statistics.username", this.localDatabase.getUsername());
        String password = this.environmentVariables.getProperty("thucydides.statistics.password", this.localDatabase.getPassword());
        String dialect = this.environmentVariables.getProperty("thucydides.statistics.dialect", this.localDatabase.getDialect());
        properties.put("hibernate.connection.driver_class", driver);
        properties.put("hibernate.connection.url", url);
        properties.put("hibernate.connection.username", username);
        properties.put("hibernate.connection.password", password);
        properties.put("hibernate.dialect", dialect);
        properties.put("hibernate.connection.pool_size", "1");
        boolean databaseIsConfigured = this.databaseIsConfigured(properties);
        if (this.isUsingLocalDatabase() || !databaseIsConfigured) {
            properties.put("hibernate.hbm2ddl.auto", "update");
        } else {
            properties.put("hibernate.hbm2ddl.auto", "validate");
        }
    }

    private boolean databaseIsConfigured(Properties targetConfiguration) {
        Properties connectionProps = new Properties();
        connectionProps.put("user", targetConfiguration.getProperty("hibernate.connection.username"));
        connectionProps.put("password", targetConfiguration.getProperty("hibernate.connection.password"));
        String jdbcConnection = targetConfiguration.getProperty("hibernate.connection.url");
        try {
            Connection conn = DriverManager.getConnection(jdbcConnection, connectionProps);
            List<String> tables = this.getTablesFrom(conn);
            return tables.contains("TESTRUN");
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean isUsingLocalDatabase() {
        return this.isUsingLocalDatabase(this.environmentVariables);
    }

    @Override
    public JPAProvider getProvider() {
        return PROVIDER;
    }
}

