/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.jpa;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.jpa.EclipseLinkEnvironmentVariablesConfig;
import net.thucydides.core.jpa.HibernateEnvironmentVariablesConfig;
import net.thucydides.core.jpa.JPAProvider;
import net.thucydides.core.jpa.JPAProviderConfig;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;

public class JPAProviderConfigFactory {
    public static final JPAProvider DEFAULT_PROVIDER = JPAProvider.EclipseLink;

    public static JPAProviderConfig getJPAProviderConfig(EnvironmentVariables environmentVariables, LocalDatabase localDatabase) {
        String providerProperty = ThucydidesSystemProperty.JPA_PROVIDER.from(environmentVariables, DEFAULT_PROVIDER.name());
        JPAProvider provider = JPAProviderConfigFactory.getJPAProviderFromProperty(providerProperty);
        return JPAProviderConfigFactory.getJPAProviderConfig(provider, environmentVariables, localDatabase);
    }

    private static JPAProvider getJPAProviderFromProperty(String providerProperty) {
        JPAProvider provider = JPAProvider.Hibernate;
        try {
            provider = JPAProvider.valueOf(providerProperty);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return provider;
    }

    private static JPAProviderConfig getJPAProviderConfig(JPAProvider provider, EnvironmentVariables environmentVariables, LocalDatabase localDatabase) {
        switch (provider) {
            case EclipseLink: {
                return new EclipseLinkEnvironmentVariablesConfig(environmentVariables, localDatabase);
            }
        }
        return new HibernateEnvironmentVariablesConfig(environmentVariables, localDatabase);
    }
}

