/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.userstories;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;

public class UserStoryLoader {
    public List<StoryTestResults> loadFrom(File reportDirectory) throws IOException {
        ArrayList<StoryTestResults> stories = new ArrayList<StoryTestResults>();
        XMLTestOutcomeReporter testOutcomeReporter = new XMLTestOutcomeReporter();
        List<TestOutcome> testOutcomes = testOutcomeReporter.loadReportsFrom(reportDirectory);
        for (TestOutcome testOutcome : testOutcomes) {
            if (testOutcome.getUserStory() == null) continue;
            StoryTestResults storyResults = this.userStoryResultsFor(testOutcome, stories);
            storyResults.recordTestRun(testOutcome);
        }
        return stories;
    }

    private StoryTestResults userStoryResultsFor(TestOutcome testOutcome, List<StoryTestResults> storyResults) {
        Story userStory = testOutcome.getUserStory();
        for (StoryTestResults storyResult : storyResults) {
            if (!storyResult.containsResultsFor(userStory)) continue;
            return storyResult;
        }
        StoryTestResults storyTestResults = new StoryTestResults(userStory);
        storyResults.add(storyTestResults);
        return storyTestResults;
    }
}

