/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Optional;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import net.thucydides.core.requirements.model.Narrative;

public class NarrativeReader {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String TITLE_SEPARATOR = ":";

    public Optional<Narrative> loadFrom(File directory) {
        File[] narrativeFiles = directory.listFiles(this.endingInNarrative());
        if (narrativeFiles.length == 0) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this.narrativeLoadedFrom(narrativeFiles[0]));
    }

    private Narrative narrativeLoadedFrom(File narrativeFile) {
        Narrative narrative = null;
        String type = this.withoutFileExtension(narrativeFile.getName());
        try {
            BufferedReader reader = new BufferedReader(new FileReader(narrativeFile));
            Optional<String> title = this.readTitleFrom(reader);
            String text = this.readDescriptionFrom(reader);
            reader.close();
            narrative = new Narrative(title, type, text);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return narrative;
    }

    private String withoutFileExtension(String name) {
        int fileExtensionIndex = name.indexOf(".");
        return name.substring(0, fileExtensionIndex);
    }

    private Optional<String> readTitleFrom(BufferedReader reader) throws IOException {
        String titleLine = reader.readLine();
        String title = null;
        int separatorAt = titleLine.indexOf(TITLE_SEPARATOR);
        if (separatorAt > 0) {
            title = titleLine.substring(separatorAt + 1).trim();
        }
        return Optional.fromNullable(title);
    }

    private String readDescriptionFrom(BufferedReader reader) throws IOException {
        String line;
        StringBuilder description = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            description.append(line);
            description.append(NEW_LINE);
        }
        return description.toString();
    }

    private FilenameFilter endingInNarrative() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.toLowerCase().endsWith(".narrative");
            }
        };
    }
}

