/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.pages.HtmlTag;
import net.thucydides.core.pages.InternalSystemClock;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.jquery.JQueryEnabledPage;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebElementFacade {
    private final WebElement webElement;
    private final WebDriver driver;
    private final long timeoutInMilliseconds;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 250;
    private final Sleeper sleeper;
    private final Clock webdriverClock;
    private JavascriptExecutorFacade javascriptExecutorFacade;
    private InternalSystemClock clock = new InternalSystemClock();
    private static final Logger LOGGER = LoggerFactory.getLogger(WebElementFacade.class);
    private final List<String> HTML_FORM_TAGS = Arrays.asList("input", "button", "select", "textarea", "link", "option");
    private static final List<String> HTML_ELEMENTS_WITH_VALUE_ATTRIBUTE = ImmutableList.of((Object)"input", (Object)"button", (Object)"option");

    public WebElementFacade(WebDriver driver, WebElement webElement, long timeoutInMilliseconds) {
        this.driver = driver;
        this.webElement = webElement;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
    }

    protected JavascriptExecutorFacade getJavascriptExecutorFacade() {
        return this.javascriptExecutorFacade;
    }

    protected InternalSystemClock getClock() {
        return this.clock;
    }

    public WebElementFacade then(String xpathOrCssSelector) {
        WebElement nestedElement = null;
        nestedElement = PageObject.isXPath(xpathOrCssSelector) ? this.driver.findElement(By.xpath((String)xpathOrCssSelector)) : this.driver.findElement(By.cssSelector((String)xpathOrCssSelector));
        return new WebElementFacade(this.driver, nestedElement, this.timeoutInMilliseconds);
    }

    public WebElementFacade then(By selector) {
        WebElement nestedElement = this.driver.findElement(selector);
        return new WebElementFacade(this.driver, nestedElement, this.timeoutInMilliseconds);
    }

    public long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public WebElementFacade withTimeoutOf(int timeout, TimeUnit unit) {
        return new WebElementFacade(this.driver, this.webElement, TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    public boolean isVisible() {
        try {
            return this.webElement != null && this.webElement.isDisplayed();
        }
        catch (ElementNotVisibleException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    public WebElementFacade and() {
        return this;
    }

    public WebElementFacade then() {
        return this;
    }

    public boolean isCurrentlyVisible() {
        return this.isVisible();
    }

    public boolean isCurrentlyEnabled() {
        try {
            return this.webElement.isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    public void shouldBeVisible() {
        if (!this.isVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldBeCurrentlyVisible() {
        if (!this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldNotBeVisible() {
        if (this.isVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public void shouldNotBeCurrentlyVisible() {
        if (this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public boolean hasFocus() {
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        WebElement activeElement = (WebElement)js.executeScript("return window.document.activeElement");
        return this.webElement.equals(activeElement);
    }

    public boolean containsText(String value) {
        return this.webElement != null && this.webElement.getText().contains(value);
    }

    public boolean containsSelectOption(String value) {
        return this.getSelectOptions().contains(value);
    }

    public List<String> getSelectOptions() {
        List results = Collections.emptyList();
        if (this.webElement != null) {
            results = this.webElement.findElements(By.tagName((String)"option"));
        }
        return Lambda.convert((Object)results, (Converter)new ExtractText());
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldContainSelectedOption(String textValue) {
        if (!this.containsSelectOption(textValue)) {
            String errorMessage = String.format("The list element '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotContainText(String textValue) {
        if (this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldBeEnabled() {
        if (!this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public boolean isEnabled() {
        return this.webElement != null && this.webElement.isEnabled();
    }

    public void shouldNotBeEnabled() {
        if (this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should not be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public WebElementFacade type(String value) {
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.clear();
        this.webElement.sendKeys(new CharSequence[]{value});
        this.notifyScreenChange();
        return this;
    }

    public WebElementFacade typeAndEnter(String value) {
        this.waitUntilElementAvailable();
        this.clear();
        this.webElement.sendKeys(new CharSequence[]{value, Keys.ENTER});
        this.notifyScreenChange();
        return this;
    }

    public WebElementFacade typeAndTab(String value) {
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.clear();
        this.webElement.sendKeys(new CharSequence[]{value});
        this.webElement.sendKeys(new CharSequence[]{Keys.TAB});
        this.getClock().pauseFor(100L);
        this.notifyScreenChange();
        return this;
    }

    public void setWindowFocus() {
        this.getJavascriptExecutorFacade().executeScript("window.focus()");
    }

    public WebElementFacade selectByVisibleText(String label) {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByVisibleText(label);
        this.notifyScreenChange();
        return this;
    }

    public String getSelectedVisibleTextValue() {
        this.waitUntilVisible();
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getText();
    }

    public WebElementFacade selectByValue(String value) {
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByValue(value);
        this.notifyScreenChange();
        return this;
    }

    public String getSelectedValue() {
        this.waitUntilVisible();
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getAttribute("value");
    }

    public WebElementFacade selectByIndex(int indexValue) {
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByIndex(indexValue);
        this.notifyScreenChange();
        return this;
    }

    private void waitUntilElementAvailable() {
        this.waitUntilEnabled();
    }

    public boolean isPresent() {
        try {
            return this.webElement != null && (this.webElement.isDisplayed() || !this.webElement.isDisplayed());
        }
        catch (NoSuchElementException e) {
            return e.getCause().getMessage().contains("Element is not usable");
        }
    }

    public void shouldBePresent() {
        if (!this.isPresent()) {
            String errorMessage = String.format("Field should be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotBePresent() {
        if (this.isPresent()) {
            String errorMessage = String.format("Field should not be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public WebElementFacade waitUntilVisible() {
        try {
            this.waitForCondition().until(this.elementIsDisplayed());
        }
        catch (Throwable error) {
            this.throwErrorWithCauseIfPresent(error, error.getMessage());
        }
        return this;
    }

    public WebElementFacade waitUntilPresent() {
        try {
            this.waitForCondition().until(this.elementIsPresent());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, timeout.getMessage());
        }
        return this;
    }

    private void throwErrorWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new ElementNotVisibleException(finalMessage, timeout);
    }

    private ExpectedCondition<Boolean> elementIsDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return WebElementFacade.this.webElement != null && WebElementFacade.this.webElement.isDisplayed();
                }
                catch (NullPointerException e) {
                    return false;
                }
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsPresent() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacade.this.isPresent();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsNotDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !WebElementFacade.this.isCurrentlyVisible();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacade.this.webElement != null && !WebElementFacade.this.isDisabledField(WebElementFacade.this.webElement);
            }
        };
    }

    private boolean isDisabledField(WebElement webElement) {
        return this.isAFormElement(webElement) && !webElement.isEnabled();
    }

    private boolean isAFormElement(WebElement webElement) {
        if (webElement == null || webElement.getTagName() == null) {
            return false;
        }
        String tag = webElement.getTagName().toLowerCase();
        return this.HTML_FORM_TAGS.contains(tag);
    }

    private boolean hasValueAttribute(WebElement webElement) {
        String tag = webElement.getTagName().toLowerCase();
        return HTML_ELEMENTS_WITH_VALUE_ATTRIBUTE.contains(tag);
    }

    private ExpectedCondition<Boolean> elementIsNotEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacade.this.webElement != null && !WebElementFacade.this.webElement.isEnabled();
            }
        };
    }

    public Wait<WebDriver> waitForCondition() {
        return new FluentWait((Object)this.driver, this.webdriverClock, this.sleeper).withTimeout(this.timeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(250L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public WebElementFacade waitUntilNotVisible() {
        try {
            this.waitForCondition().until(this.elementIsNotDisplayed());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, "Expected hidden element was displayed");
        }
        this.notifyScreenChange();
        return this;
    }

    public String getValue() {
        this.waitUntilVisible();
        return this.webElement.getAttribute("value");
    }

    public boolean isSelected() {
        this.waitUntilVisible();
        return this.webElement.isSelected();
    }

    public String getText() {
        this.waitUntilVisible();
        return this.webElement.getText();
    }

    public WebElementFacade waitUntilEnabled() {
        try {
            this.waitForCondition().until(this.elementIsEnabled());
            this.notifyScreenChange();
            return this;
        }
        catch (TimeoutException timeout) {
            throw new ElementNotVisibleException("Expected enabled element " + this + "was not enabled", (Throwable)timeout);
        }
    }

    public WebElementFacade waitUntilDisabled() {
        try {
            this.waitForCondition().until(this.elementIsNotEnabled());
            this.notifyScreenChange();
            return this;
        }
        catch (TimeoutException timeout) {
            throw new ElementNotVisibleException("Expected disabled element " + this + "  was not disabled", (Throwable)timeout);
        }
    }

    public String getTextValue() {
        this.waitUntilPresent();
        if (!this.isVisible()) {
            return "";
        }
        if (this.valueAttributeSupportedAndDefinedIn(this.webElement)) {
            return this.getValue();
        }
        if (!StringUtils.isEmpty((CharSequence)this.webElement.getText())) {
            return this.webElement.getText();
        }
        return "";
    }

    private boolean valueAttributeSupportedAndDefinedIn(WebElement webElement) {
        return this.hasValueAttribute(webElement) && StringUtils.isNotEmpty((CharSequence)this.getValue());
    }

    public WebElementFacade click() {
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.logClick();
        this.webElement.click();
        this.notifyScreenChange();
        return this;
    }

    private void logClick() {
        LOGGER.info("Click on " + this.humanizedTabfNameFor(this.webElement));
    }

    private String humanizedTabfNameFor(WebElement webElement) {
        return HtmlTag.from(webElement).inHumanReadableForm();
    }

    public void clear() {
        this.webElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), Keys.DELETE});
        this.webElement.clear();
    }

    private void enableHighlightingIfRequired() {
        JQueryEnabledPage jQueryEnabledPage = JQueryEnabledPage.withDriver(this.driver);
        if (jQueryEnabledPage.isJQueryEnabled()) {
            jQueryEnabledPage.injectJQueryPlugins();
        }
    }

    private void notifyScreenChange() {
        StepEventBus.getEventBus().notifyScreenChange();
    }

    public String toString() {
        if (this.webElement != null) {
            return this.webElement.toString();
        }
        return "<Undefined web element>";
    }

    class ExtractText
    implements Converter<WebElement, String> {
        ExtractText() {
        }

        public String convert(WebElement from) {
            return from.getText();
        }
    }
}

