/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.database;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class LocalH2ServerDatabase
implements LocalDatabase {
    private final EnvironmentVariables environmentVariables;

    @Inject
    public LocalH2ServerDatabase(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUrl() {
        return "jdbc:h2:/" + this.getDatabasePath() + ";AUTO_SERVER=TRUE";
    }

    @Override
    public String getDriver() {
        return "org.h2.Driver";
    }

    @Override
    public String getUsername() {
        return "SA";
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public String getDialect() {
        return "org.hibernate.dialect.H2Dialect";
    }

    public String getDatabaseName() {
        String projectKey = ThucydidesSystemProperty.PROJECT_KEY.from(this.environmentVariables, Thucydides.getDefaultProjectKey());
        return StringUtils.join((Iterable)ImmutableList.of((Object)"stats", (Object)projectKey), (String)"-");
    }

    public String getDatabasePath() {
        String defaultThucydidesDirectory = this.environmentVariables.getProperty("user.home") + "/.thucydides";
        String thucydidesHomeDirectory = ThucydidesSystemProperty.THUCYDIDES_HOME.from(this.environmentVariables, defaultThucydidesDirectory);
        return thucydidesHomeDirectory + "/" + this.getDatabaseName();
    }
}

