/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.statistics.model.TestRunTag;
import org.hibernate.annotations.Immutable;

@Entity
@Immutable
public class TestRun {
    @Id
    @GeneratedValue
    private Long id;
    private String title;
    private String projectKey;
    private TestResult result;
    private Date executionDate;
    private long duration;
    @ManyToMany
    @JoinTable(name="testrun_tags", joinColumns={@JoinColumn(name="testrun_id")}, inverseJoinColumns={@JoinColumn(name="tag_id")})
    private Set<TestRunTag> tags = new HashSet<TestRunTag>();

    public TestRun() {
    }

    protected TestRun(String title, String projectKey, TestResult result, long duration, Date executionDate) {
        this.title = title;
        this.projectKey = projectKey;
        this.result = result;
        this.executionDate = executionDate;
        this.duration = duration;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public TestResult getResult() {
        return this.result;
    }

    public Date getExecutionDate() {
        return this.executionDate == null ? null : new Date(this.executionDate.getTime());
    }

    public long getDuration() {
        return this.duration;
    }

    public Set<TestRunTag> getTags() {
        return this.tags;
    }

    public static TestRun from(TestOutcome result) {
        return new TestRun(result.getTitle(), null, result.getResult(), result.getDuration(), null);
    }

    public TestRun inProject(String projectKey) {
        return new TestRun(this.getTitle(), projectKey, this.getResult(), this.getDuration(), this.getExecutionDate());
    }

    public TestRun at(Date executionDate) {
        return new TestRun(this.getTitle(), this.getProjectKey(), this.getResult(), this.getDuration(), executionDate);
    }
}

