/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.collect.Lists;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.thucydides.core.screenshots.QueuedScreenshot;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultithreadScreenshotProcessor
implements ScreenshotProcessor {
    List<Thread> screenshotThreads;
    final Queue<QueuedScreenshot> queue;
    static final int THREAD_COUNT = 5;
    private final Logger logger = LoggerFactory.getLogger(MultithreadScreenshotProcessor.class);

    public MultithreadScreenshotProcessor() {
        this.queue = new ConcurrentLinkedQueue<QueuedScreenshot>();
        this.screenshotThreads = Lists.newArrayList();
        this.start();
    }

    public void start() {
        for (int i = 0; i < 5; ++i) {
            Thread screenshotThread = new Thread(new Processor(this.queue));
            this.screenshotThreads.add(screenshotThread);
            screenshotThread.start();
        }
    }

    @Override
    public void waitUntilDone() {
        while (!this.queue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueScreenshot(QueuedScreenshot queuedScreenshot) {
        this.queue.offer(queuedScreenshot);
        Queue<QueuedScreenshot> queue = this.queue;
        synchronized (queue) {
            this.queue.notifyAll();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    class Processor
    implements Runnable {
        private final Queue<QueuedScreenshot> queue;
        boolean done = false;

        Processor(Queue<QueuedScreenshot> queue) {
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.done) {
                this.saveQueuedScreenshot();
                Queue<QueuedScreenshot> queue = this.queue;
                synchronized (queue) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private void saveQueuedScreenshot() {
            while (!this.queue.isEmpty()) {
                QueuedScreenshot queuedScreenshot = this.queue.poll();
                if (queuedScreenshot == null) continue;
                this.saveScreenshot(queuedScreenshot);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveScreenshot(QueuedScreenshot queuedScreenshot) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(queuedScreenshot.getFilename());
                ((OutputStream)stream).write(queuedScreenshot.getScreenshot());
            }
            catch (Throwable e) {
                MultithreadScreenshotProcessor.this.logger.warn("Failed to write screenshot (possibly an out of memory error): " + e.getMessage());
            }
            finally {
                if (stream != null) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }
}

