/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;

public class WebdriverInstances {
    private final Map<String, WebDriver> driverMap = new HashMap<String, WebDriver>();
    private String currentDriver;

    public WebDriver getCurrentDriver() {
        if (this.driverMap.containsKey(this.currentDriver)) {
            return this.driverMap.get(this.currentDriver);
        }
        return null;
    }

    public String getCurrentDriverName() {
        return this.currentDriver;
    }

    public void closeCurrentDriver() {
        if (this.getCurrentDriver() != null) {
            WebDriver driver = this.getCurrentDriver();
            this.closeAndQuite(driver);
            this.driverMap.remove(this.currentDriver);
            this.currentDriver = null;
        }
    }

    private void closeAndQuite(WebDriver driver) {
        driver.close();
        driver.quit();
    }

    public void resetCurrentDriver() {
        WebDriver driver;
        if (this.getCurrentDriver() != null && WebDriverFacade.class.isAssignableFrom((driver = this.getCurrentDriver()).getClass())) {
            ((WebDriverFacade)driver).reset();
        }
    }

    public boolean driverIsRegisteredFor(String driverName) {
        return this.driverMap.containsKey(this.normalized(driverName));
    }

    public WebDriver useDriver(String driverName) {
        this.currentDriver = this.normalized(driverName);
        return this.driverMap.get(this.normalized(driverName));
    }

    public void closeAllDrivers() {
        Collection<WebDriver> openDrivers = this.driverMap.values();
        for (WebDriver driver : openDrivers) {
            this.closeAndQuite(driver);
        }
        this.driverMap.clear();
        this.currentDriver = null;
    }

    public InstanceRegistration registerDriverCalled(String driverName) {
        return new InstanceRegistration(this.normalized(driverName));
    }

    private String normalized(String name) {
        return name == null ? null : name.toLowerCase();
    }

    public final class InstanceRegistration {
        private final String driverName;

        public InstanceRegistration(String driverName) {
            this.driverName = WebdriverInstances.this.normalized(driverName);
        }

        public void forDriver(WebDriver driver) {
            WebdriverInstances.this.driverMap.put(WebdriverInstances.this.normalized(this.driverName), driver);
            WebdriverInstances.this.currentDriver = WebdriverInstances.this.normalized(this.driverName);
        }
    }
}

