/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Transient;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsProvider;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.requirements.model.NarrativeReader;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;

class FileSystemRequirementsProvider
implements RequirementsProvider {
    private static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private static final List<String> DEFAULT_CAPABILITY_TYPES = ImmutableList.of((Object)"capability", (Object)"feature");
    private final String rootDirectoryPath;
    private final NarrativeReader narrativeReader;
    private final int level;
    private final EnvironmentVariables environmentVariables;
    @Transient
    private List<Requirement> requirements;

    public FileSystemRequirementsProvider() {
        this(DEFAULT_ROOT_DIRECTORY);
    }

    public FileSystemRequirementsProvider(String rootDirectory, int level) {
        this(rootDirectory, level, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public FileSystemRequirementsProvider(String rootDirectory, int level, EnvironmentVariables environmentVariables) {
        this.rootDirectoryPath = rootDirectory;
        this.level = level;
        this.narrativeReader = new NarrativeReader();
        this.environmentVariables = environmentVariables;
    }

    public FileSystemRequirementsProvider(String rootDirectory) {
        this(rootDirectory, 0);
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            try {
                URL rootDirectoryUrl = this.getClass().getClassLoader().getResources(this.rootDirectoryPath).nextElement();
                File rootDirectory = new File(rootDirectoryUrl.getPath());
                File[] capabilityDirectories = rootDirectory.listFiles(this.thatAreDirectories());
                this.requirements = this.loadCapabilitiesFrom(capabilityDirectories);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not load requirements from '" + this.rootDirectoryPath + "'", e);
            }
        }
        return this.requirements;
    }

    @Override
    public List<TestTag> getTagsFor(TestOutcome testOutcome) {
        String testOutcomePath = testOutcome.getPath();
        List storyPathElements = IteratorUtils.toList(Splitter.on((String)".").split((CharSequence)this.stripRootPathFrom(testOutcomePath)).iterator());
        return this.getMatchingCapabilities(this.getRequirements(), storyPathElements);
    }

    private List<TestTag> getMatchingCapabilities(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Optional<Requirement> matchingCapability = this.findMatchingCapabilityIn(this.next(storyPathElements), requirements);
        if (matchingCapability.isPresent()) {
            TestTag thisTag = TestTag.withName(((Requirement)matchingCapability.get()).getName()).andType(((Requirement)matchingCapability.get()).getType());
            List<TestTag> remainingTags = this.getMatchingCapabilities(((Requirement)matchingCapability.get()).getChildren(), this.tail(storyPathElements));
            return this.concat(thisTag, remainingTags);
        }
        return Collections.EMPTY_LIST;
    }

    private List<TestTag> concat(TestTag thisTag, List<TestTag> remainingTags) {
        ArrayList<TestTag> totalTags = new ArrayList<TestTag>();
        totalTags.add(thisTag);
        totalTags.addAll(remainingTags);
        return totalTags;
    }

    private <T> T next(List<T> elements) {
        return elements.get(0);
    }

    private <T> List<T> tail(List<T> elements) {
        return elements.subList(1, elements.size());
    }

    private Optional<Requirement> findMatchingCapabilityIn(String storyPathElement, List<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            String normalizedStoryPathElement = Inflector.getInstance().humanize(storyPathElement, new String[0]);
            if (!requirement.getName().equals(normalizedStoryPathElement)) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    private String stripRootPathFrom(String testOutcomePath) {
        String rootPath = ThucydidesSystemProperty.TEST_ROOT_PACKAGE.from(this.environmentVariables);
        if (testOutcomePath.startsWith(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private List<Requirement> loadCapabilitiesFrom(File[] capabilityDirectories) {
        return Lambda.convert((Object)capabilityDirectories, this.toCapabilities());
    }

    private Converter<File, Requirement> toCapabilities() {
        return new Converter<File, Requirement>(){

            public Requirement convert(File capabilityFileOrDirectory) {
                return FileSystemRequirementsProvider.this.readCapabilityFrom(capabilityFileOrDirectory);
            }
        };
    }

    private Requirement readCapabilityFrom(File capabilityDirectory) {
        Optional<Narrative> capabilityNarrative = this.narrativeReader.loadFrom(capabilityDirectory);
        if (capabilityNarrative.isPresent()) {
            String title = this.getTitleFromNarrativeOrDirectoryName((Narrative)capabilityNarrative.get(), capabilityDirectory);
            String type = ((Narrative)capabilityNarrative.get()).getType();
            List<Requirement> children = this.readChildrenFrom(capabilityDirectory);
            return new Requirement(title, type, ((Narrative)capabilityNarrative.get()).getText(), children);
        }
        String capabilityName = this.humanReadableVersionOf(capabilityDirectory.getName());
        List<Requirement> children = this.readChildrenFrom(capabilityDirectory);
        return new Requirement(capabilityName, this.getDefaultType(), capabilityName, children);
    }

    private String getDefaultType() {
        List<String> types = this.getCapabilityTypes();
        if (this.level > types.size() - 1) {
            return types.get(types.size() - 1);
        }
        return types.get(this.level);
    }

    private List<String> getCapabilityTypes() {
        String capabilityTypes = ThucydidesSystemProperty.CAPABILITY_TYPES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((String)capabilityTypes)) {
            Iterator types = Splitter.on((String)",").trimResults().split((CharSequence)capabilityTypes).iterator();
            return IteratorUtils.toList(types);
        }
        return DEFAULT_CAPABILITY_TYPES;
    }

    private List<Requirement> readChildrenFrom(File capabilityDirectory) {
        String childDirectory = this.rootDirectoryPath + "/" + capabilityDirectory.getName();
        FileSystemRequirementsProvider childReader = new FileSystemRequirementsProvider(childDirectory, this.level + 1, this.environmentVariables);
        return childReader.getRequirements();
    }

    private String getTitleFromNarrativeOrDirectoryName(Narrative capabilityNarrative, File capabilityDirectory) {
        if (capabilityNarrative.getTitle().isPresent()) {
            return (String)capabilityNarrative.getTitle().get();
        }
        return this.humanReadableVersionOf(capabilityDirectory.getName());
    }

    private String humanReadableVersionOf(String name) {
        return Inflector.getInstance().humanize(name, new String[0]);
    }

    private FileFilter thatAreDirectories() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }
}

