/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.RequirementsPath;
import net.thucydides.core.requirements.model.Narrative;

public class NarrativeReader {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String TITLE_SEPARATOR = ":";
    private static final String BACKSLASH = "\\\\";
    private static final String FORWARDSLASH = "/";
    private final String rootDirectory;
    private final List<String> capabilityTypes;

    protected NarrativeReader(String rootDirectory, List<String> capabilityTypes) {
        this.rootDirectory = rootDirectory;
        this.capabilityTypes = ImmutableList.copyOf(capabilityTypes);
    }

    public static NarrativeReader forRootDirectory(String rootDirectory) {
        return new NarrativeReader(rootDirectory, FileSystemRequirementsTagProvider.DEFAULT_CAPABILITY_TYPES);
    }

    public NarrativeReader withCapabilityTypes(List<String> capabilityTypes) {
        return new NarrativeReader(this.rootDirectory, capabilityTypes);
    }

    public Optional<Narrative> loadFrom(File directory) {
        return this.loadFrom(directory, 0);
    }

    public Optional<Narrative> loadFrom(File directory, int requirementsLevel) {
        File[] narrativeFiles = directory.listFiles(this.calledNarrativeDotTxt());
        if (narrativeFiles.length == 0) {
            return Optional.absent();
        }
        return this.narrativeLoadedFrom(narrativeFiles[0], requirementsLevel);
    }

    private Optional<Narrative> narrativeLoadedFrom(File narrativeFile, int requirementsLevel) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(narrativeFile));
            String title = null;
            String cardNumber = null;
            Optional<String> titleLine = this.readOptionalTitleLine(reader);
            if (titleLine.isPresent()) {
                title = this.readTitleFrom((String)titleLine.get());
                cardNumber = this.findCardNumberIn((String)titleLine.get());
            }
            String text = this.readDescriptionFrom(reader);
            String type = this.directoryLevelInRequirementsHierarchy(narrativeFile, requirementsLevel);
            reader.close();
            return Optional.of((Object)new Narrative((Optional<String>)Optional.fromNullable((Object)title), (Optional<String>)Optional.fromNullable((Object)cardNumber), type, text));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Optional.absent();
        }
    }

    private String directoryLevelInRequirementsHierarchy(File narrativeFile, int requirementsLevel) {
        String normalizedRootPath;
        String normalizedNarrativePath = this.normalized(narrativeFile.getAbsolutePath());
        int rootDirectoryStart = normalizedNarrativePath.lastIndexOf(normalizedRootPath = this.normalized(this.rootDirectory));
        int rootDirectoryEnd = rootDirectoryStart >= 0 ? rootDirectoryStart + normalizedRootPath.length() : 0;
        String relativeNarrativePath = normalizedNarrativePath.substring(rootDirectoryEnd);
        int directoryCount = RequirementsPath.fileSystemPathElements(relativeNarrativePath).size() - 1;
        int level = requirementsLevel + directoryCount - 1;
        return this.getRequirementTypeForLevel(level);
    }

    private String normalized(String path) {
        return path.replaceAll(BACKSLASH, FORWARDSLASH);
    }

    private String getRequirementTypeForLevel(int level) {
        if (level > this.capabilityTypes.size() - 1) {
            return this.capabilityTypes.get(this.capabilityTypes.size() - 1);
        }
        return this.capabilityTypes.get(level);
    }

    private Optional<String> readOptionalTitleLine(BufferedReader reader) throws IOException {
        String titleLine = reader.readLine();
        if (titleLine.contains(TITLE_SEPARATOR)) {
            return Optional.of((Object)titleLine);
        }
        return Optional.absent();
    }

    private String findCardNumberIn(String titleLine) {
        List<String> issues = Formatter.issuesIn(titleLine);
        if (!issues.isEmpty()) {
            return issues.get(0);
        }
        return null;
    }

    private String readTitleFrom(String titleLine) throws IOException {
        int separatorAt = titleLine.indexOf(TITLE_SEPARATOR);
        if (separatorAt > 0) {
            return titleLine.substring(separatorAt + 1).trim();
        }
        return null;
    }

    private String readDescriptionFrom(BufferedReader reader) throws IOException {
        String line;
        StringBuilder description = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            description.append(line);
            description.append(NEW_LINE);
        }
        return description.toString();
    }

    private FilenameFilter calledNarrativeDotTxt() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.toLowerCase().equals("narrative.txt");
            }
        };
    }
}

