/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.requirements.model.Requirement;

public class RequirementOutcome {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;
    private IssueTracking issueTracking;

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, IssueTracking issueTracking) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
        this.issueTracking = issueTracking;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public String getCardNumberWithLinks() {
        if (this.requirement.getCardNumber() != null) {
            return this.getFormatter().addLinks(this.requirement.getCardNumber());
        }
        return "";
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    public String toString() {
        return "RequirementOutcome{requirement=" + this.requirement + ", testOutcomes=" + this.testOutcomes + '}';
    }
}

