/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.CoverageFormatter;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.matchers.TestOutcomeMatchers;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.statistics.HibernateTestStatisticsProvider;
import net.thucydides.core.statistics.TestStatisticsProvider;
import net.thucydides.core.statistics.With;
import net.thucydides.core.statistics.model.TestStatistics;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutcomes {
    private final List<? extends TestOutcome> outcomes;
    private final Optional<TestOutcomes> rootOutcomes;
    private final double estimatedAverageStepCount;
    private final String label;
    private final HibernateTestStatisticsProvider testStatisticsProvider;
    private static final Integer DEFAULT_ESTIMATED_TOTAL_STEPS = 3;
    DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));

    @Inject
    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label, HibernateTestStatisticsProvider testStatisticsProvider, TestOutcomes rootOutcomes) {
        this.outcomes = ImmutableList.copyOf(outcomes);
        this.estimatedAverageStepCount = estimatedAverageStepCount;
        this.label = label;
        this.testStatisticsProvider = testStatisticsProvider;
        this.rootOutcomes = Optional.fromNullable((Object)rootOutcomes);
    }

    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label, HibernateTestStatisticsProvider testStatisticsProvider) {
        this(outcomes, estimatedAverageStepCount, label, testStatisticsProvider, null);
    }

    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount) {
        this(outcomes, estimatedAverageStepCount, "", TestOutcomes.defaultTestStatisticsProvider());
    }

    private static HibernateTestStatisticsProvider defaultTestStatisticsProvider() {
        return (HibernateTestStatisticsProvider)Injectors.getInjector().getInstance(HibernateTestStatisticsProvider.class);
    }

    protected TestOutcomes withLabel(String label) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, label, TestOutcomes.defaultTestStatisticsProvider());
    }

    public static TestOutcomes of(List<? extends TestOutcome> outcomes) {
        return new TestOutcomes(outcomes, ((Configuration)Injectors.getInjector().getInstance(Configuration.class)).getEstimatedAverageStepCount());
    }

    public static TestOutcomes withNoResults() {
        return new TestOutcomes(Collections.EMPTY_LIST, ((Configuration)Injectors.getInjector().getInstance(Configuration.class)).getEstimatedAverageStepCount());
    }

    protected TestStatisticsProvider getTestStatisticsProvider() {
        return this.testStatisticsProvider;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getTagTypes() {
        HashSet tagTypes = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            this.addTagTypesFrom(testOutcome, tagTypes);
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tagTypes), (Object)Lambda.on(String.class));
    }

    public List<String> getTagNames() {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            this.addTagNamesFrom(testOutcome, tags);
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    private void addTagNamesFrom(TestOutcome outcome, Set<String> tags) {
        for (TestTag tag : outcome.getTags()) {
            String normalizedForm = tag.getName().toLowerCase();
            if (tags.contains(normalizedForm)) continue;
            tags.add(normalizedForm);
        }
    }

    private void addTagTypesFrom(TestOutcome outcome, Set<String> tags) {
        for (TestTag tag : outcome.getTags()) {
            String normalizedForm = tag.getType().toLowerCase();
            if (tags.contains(normalizedForm)) continue;
            tags.add(normalizedForm);
        }
    }

    public List<TestTag> getTags() {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            tags.addAll(testOutcome.getTags());
        }
        return ImmutableList.copyOf((Collection)tags);
    }

    public List<String> getTagsOfType(String tagType) {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            tags.addAll(this.tagsOfType(tagType).in(testOutcome));
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    public List<String> getTagsOfTypeExcluding(String tagType, String excludedTags) {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            List<String> allTagsOfType = this.tagsOfType(tagType).in(testOutcome);
            allTagsOfType.remove(excludedTags.toLowerCase());
            tags.addAll(allTagsOfType);
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    private TagFinder tagsOfType(String tagType) {
        return new TagFinder(tagType);
    }

    public TestOutcomes getRootOutcomes() {
        return (TestOutcomes)this.rootOutcomes.or((Object)this);
    }

    public TestOutcomes forRequirement(Requirement requirement) {
        return this.withTag(requirement.getName());
    }

    public boolean containsTag(TestTag testTag) {
        return this.getTags().contains(testTag);
    }

    public TestOutcomes withTagType(String tagType) {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.havingTagType(tagType), this.outcomes)).withLabel(tagType).withRootOutcomes(this.getRootOutcomes());
    }

    private TestOutcomes withRootOutcomes(TestOutcomes rootOutcomes) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, this.label, this.testStatisticsProvider, rootOutcomes);
    }

    public TestOutcomes withTag(String tagName) {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.havingTagName(tagName), this.outcomes)).withLabel(tagName).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes withTag(TestTag tag) {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.havingTag(tag), this.outcomes)).withLabel(tag.getName()).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes withHistory() {
        return TestOutcomes.of(Lambda.convert(this.outcomes, this.toOutcomesWithHistory()));
    }

    private Converter<TestOutcome, TestOutcome> toOutcomesWithHistory() {
        return new Converter<TestOutcome, TestOutcome>(){

            public TestOutcome convert(TestOutcome testOutcome) {
                TestStatistics statistics = TestOutcomes.this.testStatisticsProvider.statisticsForTests(With.title(testOutcome.getTitle()));
                testOutcome.setStatistics(statistics);
                return testOutcome;
            }
        };
    }

    public TestOutcomes getFailingTests() {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.withResult(TestResult.FAILURE), this.outcomes)).withLabel(this.labelForTestsWithStatus("failing tests")).withRootOutcomes(this.getRootOutcomes());
    }

    private String labelForTestsWithStatus(String status) {
        if (StringUtils.isEmpty((CharSequence)this.label)) {
            return status;
        }
        return this.label + " (" + status + ")";
    }

    public TestOutcomes getPassingTests() {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.withResult(TestResult.SUCCESS), this.outcomes)).withLabel(this.labelForTestsWithStatus("passing tests")).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes getPendingTests() {
        List<TestOutcome> pendingOrSkippedOutcomes = this.outcomesWithResults(this.outcomes, TestResult.PENDING, TestResult.SKIPPED);
        return TestOutcomes.of(pendingOrSkippedOutcomes).withLabel(this.labelForTestsWithStatus("pending tests")).withRootOutcomes(this.getRootOutcomes());
    }

    private List<TestOutcome> outcomesWithResults(List<? extends TestOutcome> outcomes, TestResult ... possibleResults) {
        ArrayList validOutcomes = Lists.newArrayList();
        List<TestResult> possibleResultsList = Arrays.asList(possibleResults);
        for (TestOutcome testOutcome : outcomes) {
            if (!possibleResultsList.contains((Object)testOutcome.getResult())) continue;
            validOutcomes.add(testOutcome);
        }
        return validOutcomes;
    }

    public List<? extends TestOutcome> getTests() {
        return Lambda.sort(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getTitle());
    }

    public Long getDuration() {
        Long total = 0L;
        for (TestOutcome testOutcome : this.outcomes) {
            total = total + testOutcome.getDuration();
        }
        return total;
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.getDuration()).inSeconds();
    }

    public int getTotal() {
        return this.outcomes.size();
    }

    public TestResult getResult() {
        TestResultList testResults = TestResultList.of(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.outcomes, this.toTestResults());
    }

    private Converter<? extends TestOutcome, TestResult> toTestResults() {
        return new Converter<TestOutcome, TestResult>(){

            public TestResult convert(TestOutcome step) {
                return step.getResult();
            }
        };
    }

    public int getStepCount() {
        return Lambda.sum((Object)Lambda.extract(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount())).intValue();
    }

    public int getSuccessCount() {
        return Lambda.select(this.outcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSuccess())).size();
    }

    public int getFailureCount() {
        return Lambda.select(this.outcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isFailure())).size();
    }

    public int getPendingCount() {
        return Lambda.select(this.outcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isPending())).size();
    }

    public int getSkipCount() {
        return Lambda.select(this.outcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSkipped())).size();
    }

    public Double getPercentagePassingStepCount() {
        int passingStepCount = this.countStepsWithResultThat((Matcher<TestResult>)Matchers.is((Object)((Object)TestResult.SUCCESS)));
        return (double)passingStepCount / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentagePassingTestCount() {
        return (double)this.getPassingTests().getTotal() / (double)this.getTotal();
    }

    public Double getPercentageFailingTestCount() {
        return (double)this.getFailingTests().getTotal() / (double)this.getTotal();
    }

    public Double getPercentagePendingTestCount() {
        int notPassingOrFailing = this.getTotal() - this.getPassingTests().getTotal() - this.getFailingTests().getTotal();
        return (double)notPassingOrFailing / (double)this.getTotal();
    }

    public String getDecimalPercentagePassingStepCount() {
        return this.formatAsDecimal(this.getPercentagePassingStepCount());
    }

    public String getDecimalPercentagePendingStepCount() {
        return this.formatAsDecimal(this.getPercentagePendingStepCount());
    }

    public String getDecimalPercentageFailingStepCount() {
        return this.formatAsDecimal(this.getPercentageFailingStepCount());
    }

    public String getDecimalPercentagePassingTestCount() {
        return this.formatAsDecimal(this.getPercentagePassingTestCount());
    }

    public String getDecimalPercentagePendingTestCount() {
        return this.formatAsDecimal(this.getPercentagePendingTestCount());
    }

    public String getDecimalPercentageFailingTestCount() {
        return this.formatAsDecimal(this.getPercentageFailingTestCount());
    }

    private String formatAsDecimal(Double value) {
        return this.decimalFormat.format(value);
    }

    public Double getPercentageFailingStepCount() {
        int failingStepCount = this.countStepsWithResultThat((Matcher<TestResult>)Matchers.is((Object)((Object)TestResult.FAILURE)));
        return (double)failingStepCount / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentagePendingStepCount() {
        int passingOrFailingSteps = this.countStepsWithResultThat((Matcher<TestResult>)Matchers.isOneOf((Object[])new TestResult[]{TestResult.SUCCESS, TestResult.FAILURE}));
        if (passingOrFailingSteps == 0) {
            return 1.0;
        }
        int pendingSteps = this.getEstimatedTotalStepCount() - passingOrFailingSteps;
        return (double)pendingSteps / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public CoverageFormatter getFormatted() {
        return new CoverageFormatter(this.getPercentagePassingStepCount(), this.getPercentagePendingStepCount(), this.getPercentageFailingStepCount());
    }

    private int countStepsWithResultThat(Matcher<TestResult> matchingResult) {
        List matchingTests = Lambda.select(this.outcomes, (Matcher)Lambda.having((Object)((Object)((TestOutcome)Lambda.on(TestOutcome.class)).getResult()), matchingResult));
        return matchingTests.isEmpty() ? 0 : (Integer)Lambda.sum((Object)matchingTests, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount());
    }

    private Integer getEstimatedTotalStepCount() {
        int estimatedTotalSteps = this.getStepCount() + this.estimatedUnimplementedStepCount();
        return estimatedTotalSteps == 0 ? DEFAULT_ESTIMATED_TOTAL_STEPS : estimatedTotalSteps;
    }

    private Integer estimatedUnimplementedStepCount() {
        return (int)Math.round(this.getAverageTestSize() * (double)this.totalUnimplementedTests());
    }

    public double getAverageTestSize() {
        if (this.totalImplementedTests() > 0) {
            return (double)this.getStepCount() / (double)this.totalImplementedTests();
        }
        return this.estimatedAverageStepCount;
    }

    public double getRecentStability() {
        if (this.outcomes.isEmpty()) {
            return 0.0;
        }
        return (Double)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getRecentStability()) / (double)this.outcomes.size();
    }

    public double getOverallStability() {
        if (this.outcomes.isEmpty()) {
            return 0.0;
        }
        return (Double)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getOverallStability()) / (double)this.outcomes.size();
    }

    private int totalUnimplementedTests() {
        return this.getTotal() - this.totalImplementedTests();
    }

    private int totalImplementedTests() {
        return Lambda.filter((Matcher)Lambda.having((Object)((TestOutcome)Lambda.on(TestOutcome.class)).getTestSteps().isEmpty(), (Matcher)Matchers.is((Object)false)), this.outcomes).size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TagFinder {
        private final String tagType;

        private TagFinder(String tagType) {
            this.tagType = tagType;
        }

        List<String> in(TestOutcome testOutcome) {
            ArrayList matchingTags = Lists.newArrayList();
            for (TestTag tag : testOutcome.getTags()) {
                if (tag.getType().compareToIgnoreCase(this.tagType) != 0) continue;
                matchingTags.add(tag.getName().toLowerCase());
            }
            return matchingTags;
        }
    }
}

