/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.digest.Digest;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class ReportNamer {
    private ReportType type;

    public static ReportNamer forReportType(ReportType type) {
        return new ReportNamer(type);
    }

    private ReportNamer(ReportType type) {
        this.type = type;
    }

    public String getNormalizedTestNameFor(TestOutcome testOutcome) {
        String testName = this.getBaseTestNameFor(testOutcome);
        return this.appendSuffixTo(Digest.ofTextValue(testName));
    }

    private String getBaseTestNameFor(TestOutcome testOutcome) {
        String testName = "";
        if (testOutcome.getUserStory() != null) {
            testName = NameConverter.underscore(testOutcome.getUserStory().getName());
        }
        String scenarioName = NameConverter.underscore(testOutcome.getQualifiedMethodName());
        return NameConverter.withNoIssueNumbers(this.appendToIfNotNull(testName, scenarioName));
    }

    public String getSimpleTestNameFor(TestOutcome testOutcome) {
        String testName = "";
        if (testOutcome.getUserStory() != null) {
            testName = NameConverter.underscore(testOutcome.getUserStory().getName());
        }
        String scenarioName = NameConverter.underscore(testOutcome.getMethodName());
        testName = NameConverter.withNoIssueNumbers(NameConverter.withNoArguments(this.appendToIfNotNull(testName, scenarioName)));
        return this.appendSuffixTo(Digest.ofTextValue(testName));
    }

    private String appendToIfNotNull(String baseString, String nextElement) {
        if (StringUtils.isNotEmpty((CharSequence)baseString)) {
            return baseString + "_" + nextElement;
        }
        return nextElement;
    }

    public String getNormalizedTestNameFor(Story userStory) {
        return this.getNormalizedTestNameFor(userStory.getName());
    }

    public String getNormalizedTestNameFor(ApplicationFeature feature) {
        return this.getNormalizedTestNameFor(feature.getName());
    }

    public String getNormalizedTestNameFor(String name) {
        String testNameWithUnderscores = NameConverter.underscore(name.toLowerCase());
        return this.appendSuffixTo(Digest.ofTextValue(testNameWithUnderscores));
    }

    private String appendSuffixTo(String testNameWithUnderscores) {
        if (this.type == ReportType.ROOT) {
            return testNameWithUnderscores;
        }
        return testNameWithUnderscores + "." + this.type.toString();
    }
}

