/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.model.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultList {
    private final List<TestResult> testResults;

    protected TestResultList(List<TestResult> testResults) {
        this.testResults = testResults;
    }

    public static TestResultList of(List<TestResult> testResults) {
        return new TestResultList(testResults);
    }

    public static TestResultList of(TestResult ... testResults) {
        return new TestResultList(Arrays.asList(testResults));
    }

    public boolean isEmpty() {
        return this.testResults.isEmpty();
    }

    public TestResult getOverallResult() {
        if (this.testResults.isEmpty()) {
            return TestResult.PENDING;
        }
        if (this.testResults.contains((Object)TestResult.ERROR)) {
            return TestResult.ERROR;
        }
        if (this.testResults.contains((Object)TestResult.FAILURE)) {
            return TestResult.FAILURE;
        }
        if (this.testResults.contains((Object)TestResult.PENDING)) {
            return TestResult.PENDING;
        }
        if (this.containsOnly(TestResult.IGNORED)) {
            return TestResult.IGNORED;
        }
        if (this.containsOnly(TestResult.SKIPPED)) {
            return TestResult.SKIPPED;
        }
        if (this.containsOnly(TestResult.SUCCESS, TestResult.IGNORED, TestResult.SKIPPED)) {
            return TestResult.SUCCESS;
        }
        return TestResult.SUCCESS;
    }

    private boolean containsOnly(TestResult ... values) {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0);
        List<TestResult> authorizedTypes = Arrays.asList(values);
        for (TestResult result : this.testResults) {
            if (authorizedTypes.contains((Object)result)) continue;
            return false;
        }
        return true;
    }
}

